/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Database;
import org.h2.expression.Aggregate;
import org.h2.expression.AggregateData;
import org.h2.message.DbException;
import org.h2.util.ValueHashMap;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

class AggregateDataDefault
extends AggregateData {
    private final Aggregate.AggregateType aggregateType;
    private long count;
    private ValueHashMap<AggregateDataDefault> distinctValues;
    private Value value;
    private double m2;
    private double mean;

    AggregateDataDefault(Aggregate.AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Override
    void add(Database database, int n, boolean bl, Value value) {
        if (value == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        if (bl) {
            if (this.distinctValues == null) {
                this.distinctValues = ValueHashMap.newInstance();
            }
            this.distinctValues.put(value, this);
            return;
        }
        switch (this.aggregateType) {
            case SUM: {
                if (this.value == null) {
                    this.value = value.convertTo(n);
                    break;
                }
                value = value.convertTo(this.value.getType());
                this.value = this.value.add(value);
                break;
            }
            case AVG: {
                if (this.value == null) {
                    this.value = value.convertTo(DataType.getAddProofType(n));
                    break;
                }
                value = value.convertTo(this.value.getType());
                this.value = this.value.add(value);
                break;
            }
            case MIN: {
                if (this.value != null && database.compare(value, this.value) >= 0) break;
                this.value = value;
                break;
            }
            case MAX: {
                if (this.value != null && database.compare(value, this.value) <= 0) break;
                this.value = value;
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                double d = value.getDouble();
                if (this.count == 1L) {
                    this.mean = d;
                    this.m2 = 0.0;
                    break;
                }
                double d2 = d - this.mean;
                this.mean += d2 / (double)this.count;
                this.m2 += d2 * (d - this.mean);
                break;
            }
            case BOOL_AND: {
                value = value.convertTo(1);
                if (this.value == null) {
                    this.value = value;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() && value.getBoolean());
                break;
            }
            case BOOL_OR: {
                value = value.convertTo(1);
                if (this.value == null) {
                    this.value = value;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() || value.getBoolean());
                break;
            }
            case BIT_AND: {
                if (this.value == null) {
                    this.value = value.convertTo(n);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() & value.getLong()).convertTo(n);
                break;
            }
            case BIT_OR: {
                if (this.value == null) {
                    this.value = value.convertTo(n);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() | value.getLong()).convertTo(n);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
    }

    @Override
    Value getValue(Database database, int n, boolean bl) {
        if (bl) {
            this.count = 0L;
            this.groupDistinct(database, n);
        }
        Value value = null;
        switch (this.aggregateType) {
            case SUM: 
            case MIN: 
            case MAX: 
            case BOOL_AND: 
            case BOOL_OR: 
            case BIT_AND: 
            case BIT_OR: {
                value = this.value;
                break;
            }
            case AVG: {
                if (this.value == null) break;
                value = AggregateDataDefault.divide(this.value, this.count);
                break;
            }
            case STDDEV_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case STDDEV_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case VAR_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(this.m2 / (double)this.count);
                break;
            }
            case VAR_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(this.m2 / (double)(this.count - 1L));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return value == null ? ValueNull.INSTANCE : value.convertTo(n);
    }

    private static Value divide(Value value, long l) {
        if (l == 0L) {
            return ValueNull.INSTANCE;
        }
        int n = Value.getHigherOrder(value.getType(), 5);
        Value value2 = ValueLong.get(l).convertTo(n);
        value = value.convertTo(n).divide(value2);
        return value;
    }

    private void groupDistinct(Database database, int n) {
        if (this.distinctValues == null) {
            return;
        }
        this.count = 0L;
        for (Value value : this.distinctValues.keys()) {
            this.add(database, n, false, value);
        }
    }
}

