/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Option;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.cli.commands.Action;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InvalidOptionsError;
import org.apache.activemq.artemis.cli.commands.OptionsUtil;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public abstract class ActionAbstract
implements Action {
    @Option(name={"--verbose"}, description="Adds more information on the execution")
    public boolean verbose;
    private String brokerInstance;
    private String brokerHome;
    private String brokerEtc;
    private URI brokerInstanceURI;
    protected ActionContext context;

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setHomeValues(File brokerHome, File brokerInstance) {
        if (brokerHome != null) {
            this.brokerHome = brokerHome.getAbsolutePath();
        }
        if (brokerInstance != null) {
            this.brokerInstance = brokerInstance.getAbsolutePath();
        }
    }

    @Override
    public String getBrokerInstance() {
        if (this.brokerInstance == null) {
            this.brokerInstance = System.getProperty("artemis.instance");
            if (this.brokerInstance != null) {
                this.brokerInstance = this.brokerInstance.replace("\\", "/");
                System.setProperty("artemis.instance", this.brokerInstance);
            }
        }
        return this.brokerInstance;
    }

    protected String getBrokerURLInstance() {
        block5: {
            if (this.getBrokerInstance() != null) {
                try {
                    Configuration brokerConfiguration = this.getBrokerConfiguration();
                    for (TransportConfiguration acceptorConfiguration : brokerConfiguration.getAcceptorConfigurations()) {
                        if (!acceptorConfiguration.getName().equals("artemis")) continue;
                        Map acceptorParams = acceptorConfiguration.getParams();
                        String scheme = ConfigurationHelper.getStringProperty((String)"scheme", (String)"tcp", (Map)acceptorParams);
                        String host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)acceptorParams);
                        int port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)acceptorParams);
                        if (InetAddress.getByName(host).isAnyLocalAddress()) {
                            host = "localhost";
                        }
                        return new URI(scheme, null, host, port, null, null, null).toString();
                    }
                }
                catch (Exception e) {
                    if (!this.isVerbose()) break block5;
                    System.out.print("Can not get the broker url instance: " + e.toString());
                }
            }
        }
        return null;
    }

    protected Configuration getBrokerConfiguration() throws Exception {
        FileConfiguration fileConfiguration = new FileConfiguration();
        String brokerConfiguration = new File(new File(this.getBrokerEtc()), "broker.xml").toURI().toASCIIString();
        FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(brokerConfiguration);
        fileDeploymentManager.addDeployable((Deployable)fileConfiguration);
        fileDeploymentManager.readConfiguration();
        return fileConfiguration;
    }

    public String getBrokerEtc() {
        if (this.brokerEtc == null) {
            this.brokerEtc = System.getProperty("artemis.instance.etc");
            this.brokerEtc = this.brokerEtc != null ? this.brokerEtc.replace("\\", "/") : this.getBrokerInstance() + "/etc";
        }
        return this.brokerEtc;
    }

    public URI getBrokerURIInstance() {
        if (this.brokerInstanceURI == null) {
            String instanceProperty = this.getBrokerInstance();
            File artemisInstance = null;
            if (artemisInstance == null && instanceProperty != null) {
                artemisInstance = new File(instanceProperty);
            }
            if (artemisInstance != null) {
                this.brokerInstanceURI = artemisInstance.toURI();
            }
        }
        return this.brokerInstanceURI;
    }

    @Override
    public String getBrokerHome() {
        if (this.brokerHome == null) {
            this.brokerHome = System.getProperty("artemis.home");
            if (this.brokerHome != null) {
                this.brokerHome = this.brokerHome.replace("\\", "/");
                System.setProperty("artemis.home", this.brokerHome);
            }
            if (this.brokerHome == null) {
                this.brokerHome = ".";
            }
        }
        return this.brokerHome;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.context = context;
        return null;
    }

    @Override
    public void checkOptions(String[] options) throws InvalidOptionsError {
        OptionsUtil.checkCommandOptions(this.getClass(), options);
    }
}

