/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.common.Node;
import io.vertx.kafka.client.common.PartitionInfoConverter;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class PartitionInfo {
    private List<Node> inSyncReplicas;
    private Node leader;
    private int partition;
    private List<Node> replicas;
    private String topic;

    public PartitionInfo() {
    }

    public PartitionInfo(List<Node> inSyncReplicas, Node leader, int partition, List<Node> replicas, String topic) {
        this.inSyncReplicas = inSyncReplicas;
        this.leader = leader;
        this.partition = partition;
        this.replicas = replicas;
        this.topic = topic;
    }

    public PartitionInfo(JsonObject json) {
        PartitionInfoConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public List<Node> getInSyncReplicas() {
        return this.inSyncReplicas;
    }

    public PartitionInfo setInSyncReplicas(List<Node> inSyncReplicas) {
        this.inSyncReplicas = inSyncReplicas;
        return this;
    }

    public Node getLeader() {
        return this.leader;
    }

    public PartitionInfo setLeader(Node leader) {
        this.leader = leader;
        return this;
    }

    public int getPartition() {
        return this.partition;
    }

    public PartitionInfo setPartition(int partition) {
        this.partition = partition;
        return this;
    }

    public List<Node> getReplicas() {
        return this.replicas;
    }

    public PartitionInfo setReplicas(List<Node> replicas) {
        this.replicas = replicas;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public PartitionInfo setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PartitionInfoConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return "PartitionInfo{topic=" + this.topic + ", partition=" + this.partition + ", inSyncReplicas=" + this.inSyncReplicas + ", leader=" + this.leader + ", replicas=" + this.replicas + "}";
    }
}

