/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class HornetQThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final int threadPriority;
    private final boolean daemon;
    private final ClassLoader tccl;
    private final AccessControlContext acc;

    public HornetQThreadFactory(String groupName, boolean daemon, ClassLoader tccl) {
        this.group = new ThreadGroup(groupName + "-" + System.identityHashCode(this));
        this.threadPriority = 5;
        this.tccl = tccl;
        this.daemon = daemon;
        this.acc = System.getSecurityManager() == null ? null : AccessController.getContext();
    }

    @Override
    public Thread newThread(Runnable command) {
        if (this.acc != null && System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new ThreadCreateAction(command), this.acc);
        }
        return this.createThread(command);
    }

    private Thread createThread(Runnable command) {
        Thread t = new Thread(this.group, command, "Thread-" + this.threadCount.getAndIncrement() + " (" + this.group.getName() + ")");
        t.setDaemon(this.daemon);
        t.setPriority(this.threadPriority);
        t.setContextClassLoader(this.tccl);
        return t;
    }

    private final class ThreadCreateAction
    implements PrivilegedAction<Thread> {
        private final Runnable target;

        private ThreadCreateAction(Runnable target) {
            this.target = target;
        }

        @Override
        public Thread run() {
            return HornetQThreadFactory.this.createThread(this.target);
        }
    }
}

