/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Timer {
    private static final Logger LOGGER = FacesLogger.TIMING.getLogger();
    private final Level logLevel;
    private long start;
    private long stop;

    private Timer(Level logLevel) {
        this.logLevel = logLevel;
    }

    public static Timer getInstance() {
        return Timer.getInstance(Level.FINE);
    }

    public static Timer getInstance(Level logLevel) {
        if (LOGGER.isLoggable(logLevel)) {
            return new Timer(logLevel);
        }
        return null;
    }

    public void startTiming() {
        this.start = System.currentTimeMillis();
    }

    public void stopTiming() {
        this.stop = System.currentTimeMillis();
    }

    public void logResult(String taskInfo) {
        if (LOGGER.isLoggable(this.logLevel)) {
            LOGGER.log(this.logLevel, " [TIMING] - [" + this.getTimingResult() + "ms] : " + taskInfo);
        }
    }

    private long getTimingResult() {
        return this.stop - this.start;
    }
}

