/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;

public class StatsEnvelope<T> {
    public static final byte HIT = 1;
    public static final byte MISS = 2;
    public static final byte CREATE = 4;
    public static final byte UPDATE = 8;
    public static final byte DELETE = 16;
    private final T value;
    private final byte flags;

    public static <T> StatsEnvelope<T> create(T returnValue, CacheEntry<?, ?> e, boolean exists, boolean isRead) {
        byte flags = 0;
        if (isRead) {
            flags = exists ? (byte)((byte)(flags | 1)) : (byte)((byte)(flags | 2));
        }
        if (exists) {
            if (e.getValue() == null) {
                flags = (byte)(flags | 0x10);
            } else if (e.isChanged()) {
                flags = (byte)(flags | 8);
            }
        } else if (e.getValue() != null) {
            flags = (byte)(flags | 4);
        }
        return new StatsEnvelope<T>(returnValue, flags);
    }

    public static <R> StatsEnvelope create(R ret, boolean isNull) {
        return new StatsEnvelope<R>(ret, isNull ? (byte)2 : 1);
    }

    public static Object unpack(InvocationContext ctx, VisitableCommand command, Object o) {
        return ((StatsEnvelope)o).value;
    }

    public static Object unpackCollection(InvocationContext ctx, VisitableCommand command, Object o) {
        return ((Collection)o).stream().map(StatsEnvelope::value).collect(Collectors.toList());
    }

    public static Object unpackStream(InvocationContext ctx, VisitableCommand command, Object o) {
        return ((Stream)o).map(StatsEnvelope::value);
    }

    private StatsEnvelope(T value, byte flags) {
        this.value = value;
        this.flags = flags;
    }

    public T value() {
        return this.value;
    }

    public byte flags() {
        return this.flags;
    }

    public String toString() {
        return "StatsEnvelope{value=" + this.value + ", flags=" + ((this.flags & 1) != 0 ? (char)'H' : '_') + ((this.flags & 2) != 0 ? (char)'M' : '_') + ((this.flags & 4) != 0 ? (char)'C' : '_') + ((this.flags & 8) != 0 ? (char)'U' : '_') + ((this.flags & 0x10) != 0 ? (char)'D' : '_') + "}";
    }

    public boolean isHit() {
        return (this.flags & 1) != 0;
    }

    public boolean isMiss() {
        return (this.flags & 2) != 0;
    }

    public boolean isDelete() {
        return (this.flags & 0x10) != 0;
    }

    public static class Externalizer
    implements AdvancedExternalizer<StatsEnvelope> {
        public Set<Class<? extends StatsEnvelope>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{StatsEnvelope.class});
        }

        public Integer getId() {
            return 137;
        }

        public void writeObject(ObjectOutput output, StatsEnvelope object) throws IOException {
            output.writeObject(object.value);
            output.writeByte(object.flags);
        }

        public StatsEnvelope readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new StatsEnvelope(input.readObject(), input.readByte());
        }
    }
}

