/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.jwt.smallrye;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;

class JwtDeploymentMarker {
    private static final AttachmentKey<Boolean> ATTACHMENT_KEY = AttachmentKey.create(Boolean.class);

    JwtDeploymentMarker() {
    }

    public static void mark(DeploymentUnit deployment) {
        JwtDeploymentMarker.toRoot(deployment).putAttachment(ATTACHMENT_KEY, (Object)true);
    }

    public static boolean isJWTDeployment(DeploymentUnit deployment) {
        Boolean val = (Boolean)JwtDeploymentMarker.toRoot(deployment).getAttachment(ATTACHMENT_KEY);
        return val != null && val != false;
    }

    private static DeploymentUnit toRoot(DeploymentUnit deployment) {
        DeploymentUnit result = deployment;
        DeploymentUnit parent = result.getParent();
        while (parent != null) {
            result = parent;
            parent = result.getParent();
        }
        return result;
    }
}

