/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.AnnotatedEJBComponentDescriptionDeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;

public abstract class EJBComponentDescriptionFactory {
    protected final boolean appclient;

    protected EJBComponentDescriptionFactory(boolean appclient) {
        this.appclient = appclient;
    }

    protected void addComponent(DeploymentUnit deploymentUnit, EJBComponentDescription beanDescription) {
        EjbJarDescription ejbJarDescription = AnnotatedEJBComponentDescriptionDeploymentUnitProcessor.getEjbJarDescription(deploymentUnit);
        if (this.appclient) {
            deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_RESOLVABLE_COMPONENTS, (Object)beanDescription);
        } else {
            ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)beanDescription);
        }
    }

    static EnterpriseBeansMetaData getEnterpriseBeansMetaData(DeploymentUnit deploymentUnit) {
        EjbJarMetaData jarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (jarMetaData == null) {
            return null;
        }
        return jarMetaData.getEnterpriseBeans();
    }

    static <B extends EnterpriseBeanMetaData> B getEnterpriseBeanMetaData(DeploymentUnit deploymentUnit, String name, Class<B> expectedType) {
        EnterpriseBeansMetaData enterpriseBeansMetaData = EJBComponentDescriptionFactory.getEnterpriseBeansMetaData(deploymentUnit);
        if (enterpriseBeansMetaData == null) {
            return null;
        }
        return (B)((EnterpriseBeanMetaData)expectedType.cast(enterpriseBeansMetaData.get(name)));
    }

    protected abstract void processAnnotations(DeploymentUnit var1, CompositeIndex var2) throws DeploymentUnitProcessingException;

    protected abstract void processBeanMetaData(DeploymentUnit var1, EnterpriseBeanMetaData var2) throws DeploymentUnitProcessingException;

    protected static <T> T override(T original, T override) {
        return override != null ? override : original;
    }
}

