/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.ServiceContainerEndpointRegistry;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointMetrics;

final class WSEndpointMetrics
implements OperationStepHandler {
    static final WSEndpointMetrics INSTANCE = new WSEndpointMetrics();
    static final AttributeDefinition MIN_PROCESSING_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("min-processing-time", ModelType.INT, false).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build();
    static final AttributeDefinition MAX_PROCESSING_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-processing-time", ModelType.INT, false).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build();
    static final AttributeDefinition AVERAGE_PROCESSING_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("average-processing-time", ModelType.INT, false).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build();
    static final AttributeDefinition TOTAL_PROCESSING_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("total-processing-time", ModelType.INT, false).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build();
    static final AttributeDefinition REQUEST_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-count", ModelType.INT, false).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build();
    static final AttributeDefinition RESPONSE_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("response-count", ModelType.INT, false).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build();
    static final AttributeDefinition FAULT_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("fault-count", ModelType.INT, false).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MIN_PROCESSING_TIME, MAX_PROCESSING_TIME, AVERAGE_PROCESSING_TIME, TOTAL_PROCESSING_TIME, REQUEST_COUNT, RESPONSE_COUNT, FAULT_COUNT};

    private WSEndpointMetrics() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceRegistry registry = context.getServiceRegistry(false);
                    if (registry != null) {
                        try {
                            context.getResult().set(WSEndpointMetrics.this.getEndpointMetricsFragment(operation, registry));
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(WSEndpointMetrics.getFallbackMessage() + ": " + e.getMessage());
                        }
                    } else {
                        context.getResult().set(WSEndpointMetrics.getFallbackMessage());
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        } else {
            context.getResult().set(WSEndpointMetrics.getFallbackMessage());
        }
    }

    private ModelNode getEndpointMetricsFragment(ModelNode operation, ServiceRegistry registry) throws OperationFailedException {
        String endpointId;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        try {
            endpointId = URLDecoder.decode(address.getLastElement().getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String metricName = operation.require("name").asString();
        String webContext = endpointId.substring(0, endpointId.indexOf(":"));
        String endpointName = endpointId.substring(endpointId.indexOf(":") + 1);
        ServiceName endpointSN = WSServices.ENDPOINT_SERVICE.append(new String[]{"context=" + webContext}).append(new String[]{endpointName});
        Endpoint endpoint = ServiceContainerEndpointRegistry.getEndpoint(endpointSN);
        if (endpoint == null) {
            throw new OperationFailedException(WSLogger.ROOT_LOGGER.noMetricsAvailable());
        }
        ModelNode result = new ModelNode();
        EndpointMetrics endpointMetrics = endpoint.getEndpointMetrics();
        if (MIN_PROCESSING_TIME.getName().equals(metricName)) {
            result.set(endpointMetrics.getMinProcessingTime());
        } else if (MAX_PROCESSING_TIME.getName().equals(metricName)) {
            result.set(endpointMetrics.getMaxProcessingTime());
        } else if (AVERAGE_PROCESSING_TIME.getName().equals(metricName)) {
            result.set(endpointMetrics.getAverageProcessingTime());
        } else if (TOTAL_PROCESSING_TIME.getName().equals(metricName)) {
            result.set(endpointMetrics.getTotalProcessingTime());
        } else if (REQUEST_COUNT.getName().equals(metricName)) {
            result.set(endpointMetrics.getRequestCount());
        } else if (RESPONSE_COUNT.getName().equals(metricName)) {
            result.set(endpointMetrics.getResponseCount());
        } else if (FAULT_COUNT.getName().equals(metricName)) {
            result.set(endpointMetrics.getFaultCount());
        }
        return result;
    }

    private static String getFallbackMessage() {
        return WSLogger.ROOT_LOGGER.noMetricsAvailable();
    }
}

