/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.plugins.providers.multipart.AbstractMultipartWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;

public class HeaderFlushedAsyncOutputStream
extends AsyncOutputStream {
    private MultivaluedMap<String, Object> headers;
    private AsyncOutputStream stream;
    private boolean headersFlushed = false;

    public HeaderFlushedAsyncOutputStream(MultivaluedMap<String, Object> headers, AsyncOutputStream delegate) {
        this.headers = headers;
        this.stream = delegate;
    }

    protected CompletionStage<Void> flushHeaders() {
        CompletionStage<Object> ret = CompletableFuture.completedFuture(null);
        if (this.headersFlushed) {
            return ret;
        }
        this.headersFlushed = true;
        RuntimeDelegate delegate = RuntimeDelegate.getInstance();
        for (String key : this.headers.keySet()) {
            for (Object obj : (List)this.headers.get((Object)key)) {
                RuntimeDelegate.HeaderDelegate headerDelegate = delegate.createHeaderDelegate(obj.getClass());
                String value = headerDelegate != null ? headerDelegate.toString(obj) : obj.toString();
                ret = ret.thenCompose(v -> this.stream.asyncWrite(key.getBytes(StandardCharsets.US_ASCII))).thenCompose(v -> this.stream.asyncWrite(AbstractMultipartWriter.COLON_SPACE_BYTES)).thenCompose(v -> this.stream.asyncWrite(value.getBytes(StandardCharsets.US_ASCII))).thenCompose(v -> this.stream.asyncWrite(AbstractMultipartWriter.LINE_SEPARATOR_BYTES));
            }
        }
        return ret.thenCompose(v -> this.stream.asyncWrite(AbstractMultipartWriter.LINE_SEPARATOR_BYTES));
    }

    public void write(int i) throws IOException {
        this.flushHeaders();
        this.stream.write(i);
    }

    public void write(byte[] bytes) throws IOException {
        this.flushHeaders();
        this.stream.write(bytes);
    }

    public void write(byte[] bytes, int i, int i1) throws IOException {
        this.flushHeaders();
        this.stream.write(bytes, i, i1);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public CompletionStage<Void> asyncFlush() {
        return this.stream.asyncFlush();
    }

    public CompletionStage<Void> asyncWrite(byte[] bytes, int offset, int length) {
        return this.flushHeaders().thenCompose(v -> this.stream.asyncWrite(bytes, offset, length));
    }
}

