/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.PrincipalLogging;
import io.smallrye.jwt.auth.principal.PrincipalMessages;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.jwt.util.ResourceUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;

public class AbstractKeyLocationResolver {
    private static final String HTTP_SCHEME = "http:";
    private static final String HTTPS_SCHEME = "https:";
    protected Key key;
    protected List<JsonWebKey> jsonWebKeys;
    protected HttpsJwks httpsJwks;
    protected long lastForcedRefreshTime;
    protected Object forcedRefreshLock = new Object();
    protected JWTAuthContextInfo authContextInfo;

    public AbstractKeyLocationResolver(JWTAuthContextInfo authContextInfo) throws UnresolvableKeyException {
        this.authContextInfo = authContextInfo;
        PrincipalLogging.log.authContextInfo(authContextInfo);
    }

    protected static boolean isMatchingJwkAvailable(List<JsonWebKey> keys, String kid) {
        if (kid != null) {
            for (JsonWebKey currentJwk : keys) {
                if (!kid.equals(currentJwk.getKeyId())) continue;
                return true;
            }
        }
        return false;
    }

    protected static void verifyKid(JsonWebStructure jws, String expectedKid) throws UnresolvableKeyException {
        String kid;
        if (expectedKid != null && (kid = AbstractKeyLocationResolver.getKid(jws)) != null && !kid.equals(expectedKid)) {
            PrincipalLogging.log.invalidTokenKidHeader(kid, expectedKid);
            throw PrincipalMessages.msg.invalidTokenKid();
        }
    }

    protected static String getKid(JsonWebStructure jws) {
        return jws.getHeaders().getStringHeaderValue("kid");
    }

    protected HttpsJwks initializeHttpsJwks(String location) throws IOException {
        PrincipalLogging.log.tryCreateKeyFromHttpsJWKS();
        HttpsJwks theHttpsJwks = new HttpsJwks(location);
        theHttpsJwks.setDefaultCacheDuration(this.authContextInfo.getJwksRefreshInterval().longValue() * 60L);
        return theHttpsJwks;
    }

    protected boolean isHttpsJwksInitialized(String keyLocation) throws IOException {
        if (this.mayBeFormat(KeyFormat.JWK) && keyLocation != null && (keyLocation.startsWith(HTTPS_SCHEME) || keyLocation.startsWith(HTTP_SCHEME))) {
            this.httpsJwks = this.initializeHttpsJwks(keyLocation);
            try {
                this.httpsJwks.refresh();
                return true;
            }
            catch (JoseException ex) {
                this.httpsJwks = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean forcedHttpsJwksRefresh() {
        Object object = this.forcedRefreshLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (this.lastForcedRefreshTime == 0L || now > this.lastForcedRefreshTime + (long)(this.authContextInfo.getForcedJwksRefreshInterval() * 60 * 1000)) {
                this.lastForcedRefreshTime = now;
                try {
                    PrincipalLogging.log.kidIsNotAvailableRefreshingJWKSet();
                    this.httpsJwks.refresh();
                }
                catch (IOException | JoseException e) {
                    PrincipalLogging.log.failedToRefreshJWKSet(e);
                    return false;
                }
            } else {
                PrincipalLogging.log.matchingKidIsNotAvailableButJWTSRefreshed(this.authContextInfo.getForcedJwksRefreshInterval());
            }
        }
        return true;
    }

    protected String readKeyContent(String keyLocation) throws IOException {
        String content = ResourceUtils.readResource((String)keyLocation, (ResourceUtils.UrlStreamResolver)this.getUrlResolver());
        if (content == null) {
            throw PrincipalMessages.msg.resourceNotFound(keyLocation);
        }
        return content;
    }

    protected ResourceUtils.UrlStreamResolver getUrlResolver() {
        return new ResourceUtils.UrlStreamResolver();
    }

    protected static JsonWebKey getJsonWebKey(String kid, List<JsonWebKey> keys, String algo) {
        PrincipalLogging.log.tryCreateKeyFromJWKS();
        try {
            if (kid != null) {
                for (JsonWebKey currentJwk : keys) {
                    if (!kid.equals(currentJwk.getKeyId()) || currentJwk.getAlgorithm() != null && !algo.equals(currentJwk.getAlgorithm())) continue;
                    return currentJwk;
                }
            }
            if (!(keys.size() != 1 || kid != null && keys.get(0).getKeyId() != null || keys.get(0).getAlgorithm() != null && !algo.equals(keys.get(0).getAlgorithm()))) {
                return keys.get(0);
            }
        }
        catch (Exception e) {
            PrincipalLogging.log.failedToCreateKeyFromJWKS(e);
        }
        return null;
    }

    boolean mayBeFormat(KeyFormat format) {
        return this.isFormat(format) || this.authContextInfo.getKeyFormat() == KeyFormat.ANY;
    }

    boolean isFormat(KeyFormat format) {
        return this.authContextInfo.getKeyFormat() == format;
    }

    protected static void reportLoadKeyException(String keyContent, String keyLocation, Exception e) throws UnresolvableKeyException {
        if (keyContent != null) {
            throw PrincipalMessages.msg.failedToLoadKey(e);
        }
        throw PrincipalMessages.msg.failedToLoadKeyFromLocation(keyLocation, e);
    }

    protected static void reportUnresolvableKeyException(String keyContent, String keyLocation) throws UnresolvableKeyException {
        if (keyContent != null) {
            throw PrincipalMessages.msg.failedToLoadKeyWhileResolving();
        }
        throw PrincipalMessages.msg.failedToLoadKeyFromLocationWhileResolving(keyLocation);
    }

    protected JsonWebKey tryAsJwk(JsonWebStructure jws, String algo) throws UnresolvableKeyException {
        String kid = AbstractKeyLocationResolver.getKid(jws);
        if (this.httpsJwks != null) {
            return this.getHttpsJwk(kid, algo);
        }
        if (this.jsonWebKeys != null) {
            return AbstractKeyLocationResolver.getJsonWebKey(kid, this.jsonWebKeys, algo);
        }
        return null;
    }

    protected JsonWebKey getHttpsJwk(String kid, String algo) {
        PrincipalLogging.log.tryCreateKeyFromHttpsJWKS();
        try {
            List theKeys = this.httpsJwks.getJsonWebKeys();
            JsonWebKey theKey = AbstractKeyLocationResolver.getJsonWebKey(kid, theKeys, algo);
            if (theKey != null || AbstractKeyLocationResolver.isMatchingJwkAvailable(theKeys, kid)) {
                return theKey;
            }
        }
        catch (Exception e) {
            PrincipalLogging.log.failedToCreateKeyFromJWKSet(e);
        }
        this.forcedHttpsJwksRefresh();
        try {
            PrincipalLogging.log.tryCreateKeyFromJWKSAfterRefresh();
            return AbstractKeyLocationResolver.getJsonWebKey(kid, this.httpsJwks.getJsonWebKeys(), algo);
        }
        catch (Exception e) {
            PrincipalLogging.log.failedToCreateKeyFromJWKSAfterRefresh(e);
            return null;
        }
    }

    protected JsonWebKey getJsonWebKey(String kid, String algo) {
        return AbstractKeyLocationResolver.getJsonWebKey(kid, this.jsonWebKeys, algo);
    }

    protected JsonWebKey tryJWKContent(String content, String keyId, String algo, boolean encoded) {
        this.jsonWebKeys = KeyUtils.loadJsonWebKeys((String)content);
        JsonWebKey jwk = null;
        if (this.jsonWebKeys != null && keyId != null && (jwk = AbstractKeyLocationResolver.getJsonWebKey(keyId, this.jsonWebKeys, algo)) != null) {
            if (encoded) {
                PrincipalLogging.log.keyCreatedFromEncodedJWKKeyOrJWKKeySet();
            } else {
                PrincipalLogging.log.keyCreatedFromJWKKeyOrJWKKeySet();
            }
        }
        return jwk;
    }

    protected JsonWebKey loadFromJwk(String content, String keyId, String algo) {
        JsonWebKey jwk = null;
        if (this.mayBeFormat(KeyFormat.JWK)) {
            PrincipalLogging.log.checkKeyContentIsJWKKeyOrJWKKeySet();
            jwk = this.tryJWKContent(content, keyId, algo, false);
            if (jwk != null || this.isFormat(KeyFormat.JWK)) {
                return jwk;
            }
        }
        if (this.jsonWebKeys == null && this.mayBeFormat(KeyFormat.JWK_BASE64URL)) {
            try {
                PrincipalLogging.log.checkKeyContentIsBase64EncodedJWKKeyOrJWKKeySet();
                content = new String(Base64.getUrlDecoder().decode(content.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                jwk = this.tryJWKContent(content, keyId, algo, true);
            }
            catch (IllegalArgumentException e) {
                PrincipalLogging.log.unableToDecodeContentUsingBase64(e);
            }
        }
        return jwk;
    }

    protected Key getSecretKeyFromJwk(JsonWebKey jwk) {
        if (jwk instanceof OctetSequenceJsonWebKey) {
            return ((OctetSequenceJsonWebKey)jwk).getKey();
        }
        return null;
    }

    protected X509Certificate loadPEMCertificate(String content) {
        PrincipalLogging.log.checkKeyContentIsBase64EncodedPEMCertificate();
        X509Certificate cert = null;
        try {
            cert = KeyUtils.getCertificate((String)content);
            PrincipalLogging.log.publicKeyCreatedFromEncodedPEMCertificate();
        }
        catch (Exception e) {
            PrincipalLogging.log.keyContentIsNotValidEncodedPEMCertificate(e);
        }
        return cert;
    }
}

