/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.microprofile.openapi.MicroProfileOpenAPIModel;
import org.wildfly.extension.microprofile.openapi.MicroProfileOpenAPIParser;
import org.wildfly.extension.microprofile.openapi.MicroProfileOpenAPISchema;
import org.wildfly.extension.microprofile.openapi.MicroProfileOpenAPISubsystemDefinition;

public class MicroProfileOpenAPIExtension
implements Extension {
    static final String SUBSYSTEM_NAME = "microprofile-openapi-smallrye";
    static final SubsystemResourceDescriptionResolver SUBSYSTEM_RESOLVER = new SubsystemResourceDescriptionResolver("microprofile-openapi-smallrye", MicroProfileOpenAPIExtension.class);

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, MicroProfileOpenAPIModel.CURRENT.getVersion());
        registration.registerXMLElementWriter((XMLElementWriter)new MicroProfileOpenAPIParser(MicroProfileOpenAPISchema.CURRENT));
        new MicroProfileOpenAPISubsystemDefinition().register(registration);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (MicroProfileOpenAPISchema schema : EnumSet.allOf(MicroProfileOpenAPISchema.class)) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new MicroProfileOpenAPIParser(schema));
        }
    }
}

