/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.security;

import java.net.URLDecoder;
import org.silverpeas.core.jcr.security.AccessContext;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.util.StringUtil;

public class WebDavAccessContext
implements AccessContext {
    public static final String AUTHORIZED_DOCUMENT_PATH_ATTRIBUTE = "AuthorizedDocumentPath";
    private final String grantedDocumentPath;

    public WebDavAccessContext(String grantedDocumentPath) {
        this.grantedDocumentPath = grantedDocumentPath;
    }

    @Override
    public boolean isGranted(String jcrPath, long permissions) {
        if (StringUtil.isNotDefined((String)this.grantedDocumentPath)) {
            return false;
        }
        String grantedJcrPath = URLDecoder.decode(this.grantedDocumentPath, Charsets.UTF_8);
        return grantedJcrPath.length() > jcrPath.length() ? grantedJcrPath.contains(jcrPath) : jcrPath.contains(grantedJcrPath);
    }
}

