/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.security;

import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.kernel.util.StringUtil;

public final class JCRUserCredentialsProvider {
    public static final String JCR_SYSTEM_ID = "jcr-system@domain0";

    private JCRUserCredentialsProvider() {
    }

    public static Credentials getJcrSystemCredentials() {
        return new SimpleCredentials(JCR_SYSTEM_ID, new char[0]);
    }

    public static Credentials getUserCredentials(String login, String domainId, String password) {
        return new SimpleCredentials(login + "@domain" + domainId, password.toCharArray());
    }

    public static Credentials getUserCredentials(String token) {
        return new TokenCredentials(token);
    }

    public static AuthenticationCredential getAuthCredentials(SimpleCredentials credentials) {
        String userId = credentials.getUserID();
        if (StringUtil.isNotDefined((String)userId)) {
            return null;
        }
        String[] userIdParts = userId.split("@domain");
        if (userIdParts.length != 2) {
            return null;
        }
        try {
            return AuthenticationCredential.newWithAsLogin((String)userIdParts[0]).withAsDomainId(userIdParts[1]).withAsPassword(String.valueOf(credentials.getPassword()));
        }
        catch (AuthenticationException e) {
            return null;
        }
    }
}

