/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.security;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.impl.RootProviderService;
import org.apache.jackrabbit.oak.plugins.tree.impl.TreeProviderService;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.silverpeas.core.jcr.impl.oak.security.SilverpeasAuthenticationConfiguration;
import org.silverpeas.core.jcr.impl.oak.security.SilverpeasAuthorizationConfiguration;

public class SilverpeasSecurityProvider
implements SecurityProvider {
    private final RootProvider rootProvider = new RootProviderService();
    private final TreeProvider treeProvider = new TreeProviderService();
    private final SilverpeasAuthenticationConfiguration authenticationConfig = this.initDefaultConfiguration(new SilverpeasAuthenticationConfiguration());
    private final SilverpeasAuthorizationConfiguration authorizationConfig = this.initDefaultConfiguration(new SilverpeasAuthorizationConfiguration(this));

    @Nonnull
    public ConfigurationParameters getParameters(@Nullable String name) {
        return ConfigurationParameters.EMPTY;
    }

    @Nonnull
    public Iterable<? extends SecurityConfiguration> getConfigurations() {
        return Set.of(this.authenticationConfig, this.authorizationConfig);
    }

    @Nonnull
    public <T> T getConfiguration(@Nonnull Class<T> configClass) {
        if (AuthenticationConfiguration.class == configClass) {
            return (T)((Object)this.authenticationConfig);
        }
        if (AuthorizationConfiguration.class == configClass) {
            return (T)((Object)this.authorizationConfig);
        }
        throw new IllegalArgumentException("Unsupported security configuration class " + configClass);
    }

    private <T extends SecurityConfiguration> T initDefaultConfiguration(@Nonnull T config) {
        if (config instanceof ConfigurationBase) {
            ConfigurationBase cfg = (ConfigurationBase)config;
            cfg.setRootProvider(this.rootProvider);
            cfg.setTreeProvider(this.treeProvider);
        }
        return config;
    }
}

