/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.jcr.SilverpeasRepository;
import org.silverpeas.core.jcr.impl.oak.OakRepository;
import org.silverpeas.core.jcr.util.SilverpeasJCRIndexation;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
@Service
@Singleton
public class JCRIndexDefinitionCreation
implements SilverpeasJCRIndexation {
    private static final String JCR_INDEX = "/silverpeas-oak-index.properties";
    @Inject
    private SilverpeasRepository repository;

    @Override
    public void initialize() {
        if (this.repository instanceof OakRepository) {
            SilverLogger.getLogger((Object)this).info("Initialize indexation in JCR...", new Object[0]);
            NodeBuilder indexRoot = this.getIndexRoot();
            Properties indexDefs = this.loadIndexDefinitions();
            indexDefs.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                String name = (String)key;
                String properties = (String)value;
                CharSequence[] np = (String[])Arrays.stream(properties.split(" ")).map(String::trim).toArray(String[]::new);
                if (!indexRoot.hasChildNode(name)) {
                    String prop = np.length > 1 ? "properties " : "property ";
                    SilverLogger.getLogger((Object)this).info("Create index " + name + " on " + prop + String.join((CharSequence)" and ", np), new Object[0]);
                    IndexUtils.createIndexDefinition((NodeBuilder)indexRoot, (String)name, (boolean)false, (boolean)false, Arrays.asList(np), List.of("slv:simpleDocument"));
                } else {
                    SilverLogger.getLogger((Object)this).info("Index " + name + " already created", new Object[0]);
                }
            }));
        }
    }

    private NodeBuilder getIndexRoot() {
        OakRepository oakRepository = (OakRepository)this.repository;
        NodeStore nodeStore = oakRepository.getNodeStore();
        NodeBuilder root = nodeStore.getRoot().builder();
        return IndexUtils.getOrCreateOakIndex((NodeBuilder)root);
    }

    private Properties loadIndexDefinitions() {
        InputStream indexDefsInput = this.getClass().getResourceAsStream(JCR_INDEX);
        Properties indexDefs = new Properties();
        try {
            indexDefs.load(indexDefsInput);
        }
        catch (IOException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
        return indexDefs;
    }
}

