/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.controls;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.client.Debug;
import java.io.IOException;

public class LDAPEntryChangeControl
extends LDAPControl {
    private int m_changeType;
    private String m_previousDN;
    private boolean m_hasChangeNumber;
    private int m_changeNumber;

    public LDAPEntryChangeControl(String oid, boolean critical, byte[] value) throws IOException {
        super(oid, critical, value);
        LBERDecoder decoder = new LBERDecoder();
        if (decoder == null) {
            throw new IOException("Decoding error.");
        }
        ASN1Object asnObj = decoder.decode(value);
        if (asnObj == null || !(asnObj instanceof ASN1Sequence)) {
            throw new IOException("Decoding error.");
        }
        ASN1Sequence sequence = (ASN1Sequence)asnObj;
        Debug.trace("Controls", "LDAPEntryChangeControl controlvalue =" + sequence.toString());
        ASN1Object asn1Obj = sequence.get(0);
        if (asn1Obj == null || !(asn1Obj instanceof ASN1Enumerated)) {
            throw new IOException("Decoding error.");
        }
        this.m_changeType = ((ASN1Enumerated)asn1Obj).intValue();
        if (sequence.size() > 1 && this.m_changeType == 8) {
            asn1Obj = sequence.get(1);
            if (asn1Obj == null || !(asn1Obj instanceof ASN1OctetString)) {
                throw new IOException("Decoding error get previous DN");
            }
            this.m_previousDN = ((ASN1OctetString)asn1Obj).stringValue();
        } else {
            this.m_previousDN = "";
        }
        if (sequence.size() == 3) {
            asn1Obj = sequence.get(2);
            if (asn1Obj == null || !(asn1Obj instanceof ASN1Integer)) {
                throw new IOException("Decoding error getting change number");
            }
            this.m_changeNumber = ((ASN1Integer)asn1Obj).intValue();
            this.m_hasChangeNumber = true;
        } else {
            this.m_hasChangeNumber = false;
        }
    }

    public boolean getHasChangeNumber() {
        return this.m_hasChangeNumber;
    }

    public int getChangeNumber() {
        return this.m_changeNumber;
    }

    public int getChangeType() {
        return this.m_changeType;
    }

    public String getPreviousDN() {
        return this.m_previousDN;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("LDAPEntryChangeControl: ");
        result.append("((oid=" + this.getID() + "");
        result.append(",critical=" + this.isCritical() + ")");
        result.append("(value=" + this.getValue() + "))");
        result.append("(changeType =" + this.getChangeTypeString(this.getChangeType()) + ")");
        result.append("(changeNumber =" + this.getChangeNumber() + ")");
        result.append("(PreviousDN=" + this.getPreviousDN() + "))");
        return result.toString();
    }

    private String getChangeTypeString(int changeType) {
        String changeTypeString;
        switch (changeType) {
            case 1: {
                changeTypeString = "ADD";
                break;
            }
            case 4: {
                changeTypeString = "MODIFY";
                break;
            }
            case 8: {
                changeTypeString = "MODDN";
                break;
            }
            case 2: {
                changeTypeString = "DELETE";
                break;
            }
            default: {
                changeTypeString = "Unknown change type: " + String.valueOf(changeType);
            }
        }
        return changeTypeString;
    }
}

