/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPDN;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPEntry
implements Comparable,
Externalizable {
    protected String dn;
    protected LDAPAttributeSet attrs;

    public LDAPEntry() {
        this(null, null);
    }

    public LDAPEntry(String dn) {
        this(dn, null);
    }

    public LDAPEntry(String dn, LDAPAttributeSet attrs) {
        if (dn == null) {
            dn = "";
        }
        if (attrs == null) {
            attrs = new LDAPAttributeSet();
        }
        this.dn = dn;
        this.attrs = attrs;
    }

    public LDAPAttribute getAttribute(String attrName) {
        return this.attrs.getAttribute(attrName);
    }

    public LDAPAttributeSet getAttributeSet() {
        return this.attrs;
    }

    public LDAPAttributeSet getAttributeSet(String subtype) {
        return this.attrs.getSubset(subtype);
    }

    public String getDN() {
        return this.dn;
    }

    public int compareTo(Object entry) {
        return LDAPDN.normalize(this.dn).compareTo(LDAPDN.normalize(((LDAPEntry)entry).dn));
    }

    public String toString() {
        StringBuffer result = new StringBuffer("LDAPEntry: ");
        if (this.dn != null) {
            result.append(this.dn + "; ");
        }
        if (this.attrs != null) {
            result.append(this.attrs.toString());
        }
        return result.toString();
    }

    void newLine(int indentTabs, Writer out) throws IOException {
        String tabString = "    ";
        out.write("\n");
        for (int i = 0; i < indentTabs; ++i) {
            out.write(tabString);
        }
    }

    private void writeAttribute(LDAPAttribute attr, Writer out) throws IOException {
        this.newLine(2, out);
        out.write("<attr name=\"");
        out.write(attr.getName());
        out.write("\">");
        String[] values = attr.getStringValueArray();
        byte[][] bytevalues = attr.getByteValueArray();
        for (int i = 0; i < values.length; ++i) {
            this.newLine(3, out);
            if (Base64.isValidUTF8(bytevalues[i], false)) {
                out.write("<value>");
                out.write(values[i]);
                out.write("</value>");
                continue;
            }
            out.write("<value xsi:type=\"xsd:base64Binary\">");
            out.write(Base64.encode(bytevalues[i]));
            out.write("</value>");
        }
        this.newLine(2, out);
        out.write("</attr>");
    }

    public void writeDSML(OutputStream oout) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(oout, "UTF-8");
        out.write("<LDAPEntry dn=\"");
        out.write(this.getDN());
        out.write("\">");
        Iterator i = this.getAttributeSet().iterator();
        while (i.hasNext()) {
            this.writeAttribute((LDAPAttribute)i.next(), out);
        }
        this.newLine(0, out);
        out.write("</LDAPEntry>");
        ((Writer)out).close();
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPEntry.getXMLHandler("LDAPEntry", null));
        return (LDAPEntry)xmlreader.parseXML(input);
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String dn;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                LDAPAttributeSet attrset = new LDAPAttributeSet();
                attrset.addAll((Collection)this.valuelist);
                LDAPEntry entry = new LDAPEntry(this.dn, attrset);
                this.setObject(entry);
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.dn = attributes.getValue("dn");
                if (this.dn == null) {
                    throw new SAXException("invalid entry Tag, dn is mandatory element: ");
                }
            }
        };
    }

    private void writeAttribute(LDAPAttribute attr, StringBuffer buff) throws IOException {
        buff.append(ValueXMLhandler.newLine(1));
        buff.append("<attr name=\"");
        buff.append(attr.getName());
        buff.append("\">");
        String[] values = attr.getStringValueArray();
        byte[][] bytevalues = attr.getByteValueArray();
        for (int i = 0; i < values.length; ++i) {
            buff.append(ValueXMLhandler.newLine(2));
            if (Base64.isValidUTF8(bytevalues[i], false)) {
                buff.append("<value>");
                buff.append(values[i]);
                buff.append("</value>");
                continue;
            }
            buff.append("<value xsi:type=\"xsd:base64Binary\">");
            buff.append(Base64.encode(bytevalues[i]));
            buff.append("</value>");
        }
        buff.append(ValueXMLhandler.newLine(1));
        buff.append("</attr>");
    }

    private String writeExternal0() throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String header = "";
        header = header + "*************************************************************************\n";
        header = header + "** The encrypted data above and below is the Class definition and  ******\n";
        header = header + "** other data specific to Java Serialization Protocol. The data  ********\n";
        header = header + "** which is of most application specific interest is as follows... ******\n";
        header = header + "*************************************************************************\n";
        header = header + "****************** Start of application data ****************************\n";
        header = header + "*************************************************************************\n";
        buff.append(header);
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("<LDAPEntry dn=\"");
        buff.append(this.getDN());
        buff.append("\">");
        Iterator i = this.getAttributeSet().iterator();
        while (i.hasNext()) {
            this.writeAttribute((LDAPAttribute)i.next(), buff);
        }
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("</LDAPEntry>");
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String tail = "";
        tail = tail + "*************************************************************************\n";
        tail = tail + "****************** End of application data ******************************\n";
        tail = tail + "*************************************************************************\n";
        buff.append(tail);
        buff.append(ValueXMLhandler.newLine(0));
        return buff.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.writeExternal0().getBytes());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ObjectInputStream reader = (ObjectInputStream)in;
        StringBuffer rawBuff = new StringBuffer();
        while (reader.available() != 0) {
            rawBuff.append((char)reader.read());
        }
        String readData = rawBuff.toString();
        readData = readData.substring(readData.indexOf(60), readData.lastIndexOf(62) + 1);
        StringBuffer parsedBuff = new StringBuffer();
        ValueXMLhandler.parseInput(readData, parsedBuff);
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(parsedBuff.toString().getBytes()));
        LDAPEntry readObject = (LDAPEntry)LDAPEntry.readDSML(istream);
        this.dn = readObject.getDN();
        this.attrs = readObject.getAttributeSet();
        readObject = null;
    }
}

