/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.container.service;

import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.owasp.encoder.Encode;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.questioncontainer.answer.dao.AnswerDAO;
import org.silverpeas.core.questioncontainer.answer.model.Answer;
import org.silverpeas.core.questioncontainer.answer.model.AnswerPK;
import org.silverpeas.core.questioncontainer.answer.service.AnswerService;
import org.silverpeas.core.questioncontainer.container.dao.QuestionContainerDAO;
import org.silverpeas.core.questioncontainer.container.model.Comment;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerDetail;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerPK;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerRuntimeException;
import org.silverpeas.core.questioncontainer.container.service.QuestionContainerContentManager;
import org.silverpeas.core.questioncontainer.container.service.QuestionContainerService;
import org.silverpeas.core.questioncontainer.question.dao.QuestionDAO;
import org.silverpeas.core.questioncontainer.question.model.Question;
import org.silverpeas.core.questioncontainer.question.model.QuestionPK;
import org.silverpeas.core.questioncontainer.question.service.QuestionService;
import org.silverpeas.core.questioncontainer.result.dao.QuestionResultDAO;
import org.silverpeas.core.questioncontainer.result.model.QuestionResult;
import org.silverpeas.core.questioncontainer.result.service.QuestionResultService;
import org.silverpeas.core.questioncontainer.score.dao.ScoreDAO;
import org.silverpeas.core.questioncontainer.score.model.ScoreDetail;
import org.silverpeas.core.questioncontainer.score.model.ScorePK;
import org.silverpeas.core.questioncontainer.score.service.ScoreService;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.csv.CSVRow;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Transactional(value=Transactional.TxType.NOT_SUPPORTED)
public class DefaultQuestionContainerService
implements QuestionContainerService,
ComponentInstanceDeletion {
    private static final String PENALTY_CLUE = "PC";
    private static final String OPENED_ANSWER = "OA";
    @Inject
    private QuestionService questionService;
    @Inject
    private QuestionResultService questionResultService;
    @Inject
    private AnswerService answerService;
    @Inject
    private ScoreService scoreService;

    @Override
    public Collection<QuestionContainerHeader> getQuestionContainerHeaders(List<QuestionContainerPK> pks) {
        Collection<QuestionContainerHeader> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                collection = QuestionContainerDAO.getQuestionContainers(con, pks);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    private Collection<QuestionContainerHeader> setNbMaxPoints(Collection<QuestionContainerHeader> questionContainerHeaders) {
        Iterator<QuestionContainerHeader> it = questionContainerHeaders.iterator();
        ArrayList<QuestionContainerHeader> result = new ArrayList<QuestionContainerHeader>();
        while (it.hasNext()) {
            QuestionContainerHeader questionContainerHeader = it.next();
            this.setNbMaxPoint(questionContainerHeader);
            result.add(questionContainerHeader);
        }
        return result;
    }

    private QuestionContainerHeader setNbMaxPoint(QuestionContainerHeader questionContainerHeader) {
        Collection<Question> questions;
        int nbMaxPoints = 0;
        QuestionPK questionPK = new QuestionPK(null, questionContainerHeader.getPK());
        try {
            questions = this.questionService.getQuestionsByFatherPK(questionPK, questionContainerHeader.getPK().getId());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        for (Question question : questions) {
            nbMaxPoints += question.getNbPointsMax();
        }
        questionContainerHeader.setNbMaxPoints(nbMaxPoints);
        return questionContainerHeader;
    }

    @Override
    public Collection<QuestionContainerHeader> getNotClosedQuestionContainers(QuestionContainerPK questionContainerPK) {
        Collection<QuestionContainerHeader> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                Collection<QuestionContainerHeader> questionContainerHeaders = QuestionContainerDAO.getNotClosedQuestionContainers(con, questionContainerPK);
                collection = this.setNbMaxPoints(questionContainerHeaders);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<QuestionContainerHeader> getOpenedQuestionContainers(QuestionContainerPK questionContainerPK) {
        Collection<QuestionContainerHeader> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                Collection<QuestionContainerHeader> result = QuestionContainerDAO.getOpenedQuestionContainers(con, questionContainerPK);
                collection = this.setNbMaxPoints(result);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<QuestionContainerHeader> getOpenedQuestionContainersAndUserScores(QuestionContainerPK questionContainerPK, String userId) {
        ArrayList<QuestionContainerHeader> arrayList;
        block9: {
            Connection con = this.getConnection();
            try {
                Collection<QuestionContainerHeader> questionContainerHeaders = QuestionContainerDAO.getOpenedQuestionContainers(con, questionContainerPK);
                ArrayList<QuestionContainerHeader> result = new ArrayList<QuestionContainerHeader>(questionContainerHeaders.size());
                for (QuestionContainerHeader questionContainerHeader : questionContainerHeaders) {
                    questionContainerHeader.setScores(this.getUserScoresByFatherId(questionContainerHeader.getPK(), userId));
                    result.add(this.setNbMaxPoint(questionContainerHeader));
                }
                arrayList = result;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    @Override
    public Collection<QuestionContainerHeader> getQuestionContainersWithScores(QuestionContainerPK questionContainerPK) {
        ArrayList<QuestionContainerHeader> arrayList;
        block9: {
            Connection con = this.getConnection();
            try {
                Collection<QuestionContainerHeader> questionContainerHeaders = QuestionContainerDAO.getQuestionContainers(con, questionContainerPK);
                ArrayList<QuestionContainerHeader> result = new ArrayList<QuestionContainerHeader>(questionContainerHeaders.size());
                for (QuestionContainerHeader questionContainerHeader : questionContainerHeaders) {
                    Collection<ScoreDetail> scoreDetails = this.getScoresByFatherId(questionContainerHeader.getPK());
                    if (scoreDetails == null) continue;
                    questionContainerHeader.setScores(scoreDetails);
                    result.add(this.setNbMaxPoint(questionContainerHeader));
                }
                arrayList = result;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    @Override
    public Collection<QuestionContainerHeader> getQuestionContainersWithUserScores(QuestionContainerPK questionContainerPK, String userId) {
        ArrayList<QuestionContainerHeader> arrayList;
        block9: {
            Connection con = this.getConnection();
            try {
                Collection<QuestionContainerHeader> questionContainerHeaders = QuestionContainerDAO.getQuestionContainers(con, questionContainerPK);
                Iterator<QuestionContainerHeader> it = questionContainerHeaders.iterator();
                ArrayList<QuestionContainerHeader> result = new ArrayList<QuestionContainerHeader>();
                while (it.hasNext()) {
                    QuestionContainerHeader questionContainerHeader = it.next();
                    Collection<ScoreDetail> scoreDetails = this.getUserScoresByFatherId(questionContainerHeader.getPK(), userId);
                    if (scoreDetails == null) continue;
                    questionContainerHeader.setScores(scoreDetails);
                    result.add(this.setNbMaxPoint(questionContainerHeader));
                }
                arrayList = result;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    @Override
    public Collection<QuestionContainerHeader> getClosedQuestionContainers(QuestionContainerPK questionContainerPK) {
        Collection<QuestionContainerHeader> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                Collection<QuestionContainerHeader> result = QuestionContainerDAO.getClosedQuestionContainers(con, questionContainerPK);
                collection = this.setNbMaxPoints(result);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<QuestionContainerHeader> getInWaitQuestionContainers(QuestionContainerPK questionContainerPK) {
        Collection<QuestionContainerHeader> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                Collection<QuestionContainerHeader> result = QuestionContainerDAO.getInWaitQuestionContainers(con, questionContainerPK);
                collection = this.setNbMaxPoints(result);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<ScoreDetail> getUserScoresByFatherId(QuestionContainerPK questionContainerPK, String userId) {
        Collection<ScoreDetail> scores;
        ScorePK scorePK = new ScorePK(null, questionContainerPK);
        try {
            scores = this.scoreService.getUserScoresByFatherId(scorePK, questionContainerPK.getId(), userId);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return scores;
    }

    @Override
    public Collection<ScoreDetail> getBestScoresByFatherId(QuestionContainerPK questionContainerPK, int nbBestScores) {
        ScorePK scorePK = new ScorePK(null, questionContainerPK);
        try {
            Collection<ScoreDetail> scores = this.scoreService.getBestScoresByFatherId(scorePK, nbBestScores, questionContainerPK.getId());
            return scores;
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    public Collection<ScoreDetail> getWorstScoresByFatherId(QuestionContainerPK questionContainerPK, int nbScores) {
        ScorePK scorePK = new ScorePK(null, questionContainerPK);
        try {
            Collection<ScoreDetail> scores = this.scoreService.getWorstScoresByFatherId(scorePK, nbScores, questionContainerPK.getId());
            return scores;
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    public Collection<ScoreDetail> getScoresByFatherId(QuestionContainerPK questionContainerPK) {
        ScorePK scorePK = new ScorePK(null, questionContainerPK);
        try {
            return this.scoreService.getScoresByFatherId(scorePK, questionContainerPK.getId());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    public float getAverageScoreByFatherId(QuestionContainerPK questionContainerPK) {
        ScorePK scorePK = new ScorePK(null, questionContainerPK);
        try {
            return this.scoreService.getAverageScoreByFatherId(scorePK, questionContainerPK.getId());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    public QuestionContainerDetail getQuestionContainer(QuestionContainerPK questionContainerPK, String userId) {
        Collection<Question> questions;
        QuestionContainerHeader questionContainerHeader = this.getQuestionContainerHeader(questionContainerPK);
        QuestionPK questionPK = new QuestionPK(null, questionContainerPK);
        int nbMaxPoints = 0;
        try {
            questions = this.questionService.getQuestionsByFatherPK(questionPK, questionContainerPK.getId());
            for (Question question : questions) {
                nbMaxPoints += question.getNbPointsMax();
            }
            questionContainerHeader.setNbMaxPoints(nbMaxPoints);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        Collection<QuestionResult> userVotes = this.getUserVotesToQuestionContainer(userId, questionContainerPK);
        Collection<Comment> comments = this.getComments(questionContainerPK);
        return new QuestionContainerDetail(questionContainerHeader, questions, comments, userVotes);
    }

    @Override
    public QuestionContainerHeader getQuestionContainerHeader(QuestionContainerPK questionContainerPK) {
        QuestionContainerHeader questionContainerHeader;
        block8: {
            Connection con = this.getConnection();
            try {
                questionContainerHeader = QuestionContainerDAO.getQuestionContainerHeader(con, questionContainerPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return questionContainerHeader;
    }

    @Override
    public QuestionContainerDetail getQuestionContainerByParticipationId(QuestionContainerPK questionContainerPK, String userId, int participationId) {
        Collection<Question> questions;
        Collection<QuestionResult> userVotes = null;
        QuestionContainerHeader questionContainerHeader = this.getQuestionContainerHeader(questionContainerPK);
        QuestionPK questionPK = new QuestionPK(null, questionContainerPK);
        int nbMaxPoints = 0;
        try {
            questions = this.questionService.getQuestionsByFatherPK(questionPK, questionContainerPK.getId());
            for (Question question : questions) {
                userVotes = this.questionResultService.getUserQuestionResultsToQuestionByParticipation(userId, new ResourceReference((WAPrimaryKey)question.getPK()), participationId);
                question.setQuestionResults(userVotes);
                nbMaxPoints += question.getNbPointsMax();
            }
            questionContainerHeader.setNbMaxPoints(nbMaxPoints);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        Collection<Comment> comments = this.getComments(questionContainerPK);
        return new QuestionContainerDetail(questionContainerHeader, questions, comments, userVotes);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void closeQuestionContainer(QuestionContainerPK questionContainerPK) {
        try (Connection con = this.getConnection();){
            QuestionContainerHeader qc = QuestionContainerDAO.getQuestionContainerHeader(con, questionContainerPK);
            QuestionContainerContentManager.updateSilverContentVisibility(qc, false);
            QuestionContainerDAO.closeQuestionContainer(con, questionContainerPK);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void openQuestionContainer(QuestionContainerPK questionContainerPK) {
        try (Connection con = this.getConnection();){
            QuestionContainerHeader qc = QuestionContainerDAO.getQuestionContainerHeader(con, questionContainerPK);
            QuestionContainerContentManager.updateSilverContentVisibility(qc, true);
            QuestionContainerDAO.openQuestionContainer(con, questionContainerPK);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    public int getNbVotersByQuestionContainer(QuestionContainerPK questionContainerPK) {
        int nbVoters;
        ScorePK scorePK = new ScorePK("", questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        try {
            nbVoters = this.scoreService.getNbVotersByFatherId(scorePK, questionContainerPK.getId());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return nbVoters;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void recordReplyToQuestionContainerByUser(QuestionContainerPK questionContainerPK, String userId, Map<String, List<String>> reply) {
        SimpleDateFormat formatterDB = new SimpleDateFormat("yyyy/MM/dd");
        ScorePK scorePK = new ScorePK(null, questionContainerPK);
        int participationId = this.scoreService.getUserNbParticipationsByFatherId(scorePK, questionContainerPK.getId(), userId) + 1;
        int userScore = 0;
        for (Map.Entry<String, List<String>> entry : reply.entrySet()) {
            QuestionResult result;
            AnswerPK answerPK;
            Answer answer;
            String answerId;
            String openedAnswer;
            int vectorSize;
            int questionUserScore = 0;
            QuestionPK questionPK = new QuestionPK(entry.getKey(), questionContainerPK);
            Question question = this.getQuestion(questionPK);
            List<String> answers = entry.getValue();
            int newVectorSize = vectorSize = answers.size();
            int vectorBegin = 0;
            String cluePenalty = answers.get(0);
            int penaltyValue = 0;
            if (cluePenalty.startsWith(PENALTY_CLUE)) {
                penaltyValue = Integer.parseInt(cluePenalty.substring(PENALTY_CLUE.length()));
                vectorBegin = 1;
            }
            if ((openedAnswer = answers.get(vectorSize - 1)).startsWith(OPENED_ANSWER)) {
                int answerIdIndex = vectorSize - 2;
                answerId = answers.get(answerIdIndex);
                openedAnswer = openedAnswer.substring(OPENED_ANSWER.length());
                answer = question.getAnswer(answerId);
                questionUserScore += answer.getNbPoints() - penaltyValue;
                newVectorSize = answerIdIndex;
                answerPK = new AnswerPK(answerId, questionContainerPK);
                result = new QuestionResult(null, new ResourceReference((WAPrimaryKey)questionPK), answerPK, userId, openedAnswer);
                result.setParticipationId(participationId);
                result.setNbPoints(answer.getNbPoints() - penaltyValue);
                this.saveQuestionResult(result);
                this.saveAnswerAsVote(questionPK, answerPK);
            }
            for (int i = vectorBegin; i < newVectorSize; ++i) {
                answerId = answers.get(i);
                answer = question.getAnswer(answerId);
                questionUserScore += answer.getNbPoints() - penaltyValue;
                answerPK = new AnswerPK(answerId, questionContainerPK);
                result = new QuestionResult(null, new ResourceReference((WAPrimaryKey)questionPK), answerPK, userId, null);
                result.setParticipationId(participationId);
                result.setNbPoints(answer.getNbPoints() - penaltyValue);
                this.saveQuestionResult(result);
                this.saveAnswerAsVote(questionPK, answerPK);
            }
            if (question.getNbPointsMax() < questionUserScore) {
                questionUserScore = question.getNbPointsMax();
            } else if (question.getNbPointsMin() > questionUserScore) {
                questionUserScore = question.getNbPointsMin();
            }
            userScore += questionUserScore;
        }
        ScoreDetail scoreDetail = new ScoreDetail(scorePK, questionContainerPK.getId(), userId, participationId, formatterDB.format(new Date()), userScore, 0, "");
        this.scoreService.addScore(scoreDetail);
        this.addVoter(questionContainerPK);
    }

    private void addVoter(QuestionContainerPK questionContainerPK) {
        try (Connection con = this.getConnection();){
            QuestionContainerDAO.addAVoter(con, questionContainerPK);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    private void saveAnswerAsVote(QuestionPK questionPK, AnswerPK answerPK) {
        try {
            this.answerService.recordThisAnswerAsVote(new ResourceReference((WAPrimaryKey)questionPK), answerPK);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    private void saveQuestionResult(QuestionResult result) {
        try {
            this.questionResultService.setQuestionResultToUser(result);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    private Question getQuestion(QuestionPK questionPK) {
        Question question;
        try {
            question = this.questionService.getQuestion(questionPK);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return question;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void recordReplyToQuestionContainerByUser(QuestionContainerPK questionContainerPK, String userId, Map<String, List<String>> reply, String comment, boolean isAnonymousComment) {
        this.recordReplyToQuestionContainerByUser(questionContainerPK, userId, reply);
        this.addComment(questionContainerPK, userId, comment, isAnonymousComment);
    }

    private void addComment(QuestionContainerPK questionContainerPK, String userId, String comment, boolean isAnonymousComment) {
        try (Connection con = this.getConnection();){
            Comment c = new Comment(null, questionContainerPK, userId, comment, isAnonymousComment, null);
            QuestionContainerDAO.addComment(con, c);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    public QuestionContainerPK createQuestionContainer(QuestionContainerPK questionContainerPK, QuestionContainerDetail questionContainerDetail, String userId) {
        QuestionContainerPK finalQuestionContainerPK = questionContainerPK;
        QuestionContainerHeader questionContainerHeader = questionContainerDetail.getHeader();
        questionContainerHeader.setPK(finalQuestionContainerPK);
        questionContainerHeader.setCreatorId(userId);
        try (Connection con = this.getConnection();){
            finalQuestionContainerPK = QuestionContainerDAO.createQuestionContainerHeader(con, questionContainerHeader);
            questionContainerHeader.setPK(finalQuestionContainerPK);
            QuestionContainerContentManager.createSilverContent(con, questionContainerHeader, userId, true);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        QuestionPK questionPK = new QuestionPK(null, finalQuestionContainerPK);
        Collection<Question> questions = questionContainerDetail.getQuestions();
        ArrayList<Question> q = new ArrayList<Question>(questions.size());
        for (Question question : questions) {
            question.setPK(questionPK);
            q.add(question);
        }
        try {
            this.questionService.createQuestions(q, finalQuestionContainerPK.getId());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        this.createIndex(questionContainerHeader);
        return finalQuestionContainerPK;
    }

    @Override
    @Transactional
    public void updateQuestionContainerHeader(QuestionContainerHeader questionContainerHeader) {
        try (Connection con = this.getConnection();){
            QuestionContainerDAO.updateQuestionContainerHeader(con, questionContainerHeader);
            QuestionContainerContentManager.updateSilverContentVisibility(questionContainerHeader, true);
            this.createIndex(questionContainerHeader);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateQuestions(QuestionContainerPK questionContainerPK, Collection<Question> questions) {
        QuestionPK questionPK = new QuestionPK(null, questionContainerPK);
        for (Question question : questions) {
            question.setPK(questionPK);
        }
        try {
            this.questionService.deleteQuestionsByFatherPK(questionPK, questionContainerPK.getId());
            this.questionService.createQuestions(questions, questionContainerPK.getId());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void deleteQuestionContainer(QuestionContainerPK questionContainerPK) {
        ScorePK scorePK = new ScorePK(questionContainerPK.getId(), questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        QuestionPK questionPK = new QuestionPK(questionContainerPK.getId(), questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        try {
            this.scoreService.deleteScoreByFatherPK(scorePK, questionContainerPK.getId());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        try {
            this.questionService.deleteQuestionsByFatherPK(questionPK, questionContainerPK.getId());
            this.deleteIndex(questionContainerPK);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        try (Connection con = this.getConnection();){
            QuestionContainerDAO.deleteComments(con, questionContainerPK);
            QuestionContainerDAO.deleteQuestionContainerHeader(con, questionContainerPK);
            QuestionContainerContentManager.deleteSilverContent(con, questionContainerPK);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void deleteVotes(QuestionContainerPK questionContainerPK) {
        ScorePK scorePK = new ScorePK(questionContainerPK.getId(), questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        QuestionPK questionPK = new QuestionPK(questionContainerPK.getId(), questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        try (Connection con = this.getConnection();){
            QuestionContainerHeader qch = this.getQuestionContainerHeader(questionContainerPK);
            qch.setNbVoters(0);
            this.updateQuestionContainerHeader(qch);
            this.scoreService.deleteScoreByFatherPK(scorePK, questionContainerPK.getId());
            QuestionContainerDAO.deleteComments(con, questionContainerPK);
            Collection<Question> questions = this.questionService.getQuestionsByFatherPK(questionPK, questionContainerPK.getId());
            if (questions != null && !questions.isEmpty()) {
                for (Question question : questions) {
                    QuestionPK questionPKToDelete = question.getPK();
                    this.questionResultService.deleteQuestionResultsToQuestion(new ResourceReference((WAPrimaryKey)questionPKToDelete));
                    Collection<Answer> answers = question.getAnswers();
                    ArrayList<Answer> newAnswers = new ArrayList<Answer>();
                    for (Answer answer : answers) {
                        answer.setNbVoters(0);
                        newAnswers.add(answer);
                    }
                    question.setAnswers(newAnswers);
                    this.questionService.updateQuestion(question);
                }
            }
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    private Collection<Comment> getComments(QuestionContainerPK questionContainerPK) {
        Collection<Comment> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                collection = QuestionContainerDAO.getComments(con, questionContainerPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new QuestionContainerRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<QuestionResult> getSuggestions(QuestionContainerPK questionContainerPK) {
        Collection<QuestionResult> suggestions;
        QuestionPK questionPK = new QuestionPK(questionContainerPK.getId(), questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        try {
            suggestions = this.questionResultService.getQuestionResultToQuestion(new ResourceReference((WAPrimaryKey)questionPK));
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return suggestions;
    }

    @Override
    public QuestionResult getSuggestion(String userId, QuestionPK questionPK, AnswerPK answerPK) {
        QuestionResult suggestion;
        try {
            suggestion = this.questionResultService.getUserAnswerToQuestion(userId, new ResourceReference((WAPrimaryKey)questionPK), answerPK);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return suggestion;
    }

    private Collection<QuestionResult> getUserVotesToQuestionContainer(String userId, QuestionContainerPK questionContainerPK) {
        Collection<Question> questions;
        Collection<QuestionResult> votes = null;
        QuestionPK questionPK = new QuestionPK("unknown", questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        try {
            questions = this.questionService.getQuestionsByFatherPK(questionPK, questionContainerPK.getId());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        for (Question question : questions) {
            try {
                votes = this.questionResultService.getUserQuestionResultsToQuestion(userId, new ResourceReference((WAPrimaryKey)question.getPK()));
            }
            catch (Exception e) {
                throw new QuestionContainerRuntimeException(e);
            }
            if (votes.isEmpty()) continue;
            break;
        }
        return votes;
    }

    @Override
    public float getAveragePoints(QuestionContainerPK questionContainerPK) {
        float averagePoints;
        ScorePK scorePK = new ScorePK("", questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        try {
            averagePoints = this.scoreService.getAverageScoreByFatherId(scorePK, questionContainerPK.getId());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return averagePoints;
    }

    @Override
    public int getUserNbParticipationsByFatherId(QuestionContainerPK questionContainerPK, String userId) {
        int nbPart;
        ScorePK scorePK = new ScorePK("", questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        try {
            nbPart = this.scoreService.getUserNbParticipationsByFatherId(scorePK, questionContainerPK.getId(), userId);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return nbPart;
    }

    @Override
    public ScoreDetail getUserScoreByFatherIdAndParticipationId(QuestionContainerPK questionContainerPK, String userId, int participationId) {
        ScoreDetail scoreDetail;
        ScorePK scorePK = new ScorePK("", questionContainerPK.getSpace(), questionContainerPK.getComponentName());
        try {
            scoreDetail = this.scoreService.getUserScoreByFatherIdAndParticipationId(scorePK, questionContainerPK.getId(), userId, participationId);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return scoreDetail;
    }

    @Override
    public void updateScore(QuestionContainerPK questionContainerPK, ScoreDetail scoreDetail) {
        try {
            this.scoreService.updateScore(scoreDetail);
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    private void createIndex(QuestionContainerHeader header) {
        FullIndexEntry indexEntry = null;
        if (header != null) {
            indexEntry = new FullIndexEntry(new IndexEntryKey(header.getPK().getComponentName(), "QuestionContainer", header.getPK().getId()));
            indexEntry.setTitle(header.getTitle());
            indexEntry.setPreview(header.getDescription());
            indexEntry.setCreationDate(header.getCreationDate());
            indexEntry.setCreationUser(header.getCreatorId());
            if (StringUtil.isDefined((String)header.getBeginDate())) {
                try {
                    indexEntry.setStartDate(DateUtil.parse((String)header.getBeginDate()));
                }
                catch (ParseException e) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                }
            }
            if (StringUtil.isDefined((String)header.getEndDate())) {
                try {
                    indexEntry.setEndDate(DateUtil.parse((String)header.getEndDate()));
                }
                catch (ParseException e) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                }
            }
        }
        IndexEngineProxy.addIndexEntry(indexEntry);
    }

    @Override
    public void deleteIndex(QuestionContainerPK pk) {
        IndexEntryKey indexEntry = new IndexEntryKey(pk.getComponentName(), "QuestionContainer", pk.getId());
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
    }

    @Override
    public int getSilverObjectId(QuestionContainerPK pk) {
        int silverObjectId;
        try {
            silverObjectId = QuestionContainerContentManager.getSilverObjectId(pk.getId(), pk.getComponentName());
            if (silverObjectId == -1) {
                QuestionContainerHeader questionContainerHeader = this.getQuestionContainerHeader(pk);
                silverObjectId = QuestionContainerContentManager.createSilverContent(null, questionContainerHeader, questionContainerHeader.getCreatorId(), true);
            }
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return silverObjectId;
    }

    @Override
    public List<CSVRow> exportCSV(QuestionContainerDetail questionContainer, boolean addScore) {
        try {
            if (questionContainer.getHeader().isAnonymous()) {
                return this.exportCSVForAnonymous(questionContainer, addScore);
            }
            return this.exportCSVForAuthorized(questionContainer, addScore);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<CSVRow> exportCSVForAuthorized(QuestionContainerDetail questionContainer, boolean addScore) {
        ArrayList<CSVRow> csvRows = new ArrayList<CSVRow>();
        Collection<Question> questions = questionContainer.getQuestions();
        for (Question question : questions) {
            if (question.isOpenStyle()) {
                String id = question.getPK().getId();
                QuestionContainerPK qcPK = new QuestionContainerPK(id, question.getPK().getSpaceId(), question.getPK().getInstanceId());
                Collection<QuestionResult> openAnswers = this.getSuggestions(qcPK);
                for (QuestionResult qR : openAnswers) {
                    csvRows.add(this.getCSVRow(question.getLabel(), qR.getOpenedAnswer(), User.getById((String)qR.getUserId()).getDisplayedName(), false, 0));
                }
                continue;
            }
            Collection<Answer> answers = question.getAnswers();
            for (Answer answer : answers) {
                csvRows.addAll(this.exportCSVAnswerPartForAuthorized(addScore, question, answer));
            }
        }
        return csvRows;
    }

    private List<CSVRow> exportCSVAnswerPartForAuthorized(boolean addScore, Question question, Answer answer) {
        ArrayList<CSVRow> csvRows = new ArrayList<CSVRow>();
        Collection<String> users = this.questionResultService.getUsersByAnswer(answer.getPK().getId());
        for (String user : users) {
            if (answer.isOpened()) {
                QuestionResult openAnswer = this.getSuggestion(user, question.getPK(), answer.getPK());
                CSVRow csvRow = this.getCSVRow(question.getLabel(), answer.getLabel() + " : " + openAnswer.getOpenedAnswer(), User.getById((String)user).getDisplayedName(), addScore, answer.getNbPoints());
                csvRows.add(csvRow);
                continue;
            }
            CSVRow csvRow = this.getCSVRow(question.getLabel(), answer.getLabel(), User.getById((String)user).getDisplayedName(), addScore, answer.getNbPoints());
            csvRows.add(csvRow);
        }
        return csvRows;
    }

    private List<CSVRow> exportCSVForAnonymous(QuestionContainerDetail questionContainer, boolean addScore) {
        ArrayList<CSVRow> csvRows = new ArrayList<CSVRow>();
        Collection<Question> questions = questionContainer.getQuestions();
        for (Question question : questions) {
            if (question.isOpenStyle()) {
                String id = question.getPK().getId();
                QuestionContainerPK qcPK = new QuestionContainerPK(id, question.getPK().getSpaceId(), question.getPK().getInstanceId());
                Collection<QuestionResult> openAnswers = this.getSuggestions(qcPK);
                for (QuestionResult qR : openAnswers) {
                    if (!StringUtil.isDefined((String)qR.getOpenedAnswer())) continue;
                    CSVRow csvRow = this.getCSVRow(question.getLabel(), qR.getOpenedAnswer(), "", false, 0);
                    csvRows.add(csvRow);
                }
                continue;
            }
            Collection<Answer> answers = question.getAnswers();
            for (Answer answer : answers) {
                String percent = answer.getPercent(questionContainer.getHeader().getNbVoters()) + "%";
                CSVRow csvRow = this.getCSVRow(question.getLabel(), answer.getLabel(), percent, addScore, answer.getNbPoints());
                csvRows.add(csvRow);
            }
        }
        return csvRows;
    }

    private CSVRow getCSVRow(String questionLabel, String answerLabel, String value, boolean addScore, int nbPoints) {
        CSVRow row = new CSVRow();
        if (questionLabel != null) {
            row.addCell((Object)questionLabel);
        }
        if (answerLabel != null) {
            row.addCell((Object)answerLabel);
        }
        if (value != null) {
            row.addCell((Object)value);
        }
        if (addScore) {
            row.addCell((Object)nbPoints);
        }
        return row;
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
    }

    @Override
    public String getHTMLQuestionPath(QuestionContainerDetail questionDetail) {
        String htmlPath;
        try {
            QuestionContainerHeader questionHeader = questionDetail.getHeader();
            QuestionContainerPK pk = questionHeader.getPK();
            htmlPath = this.getSpacesPath(pk.getInstanceId()) + this.getComponentLabel(pk.getInstanceId()) + " > " + Encode.forHtml((String)questionHeader.getName());
        }
        catch (Exception e) {
            throw new QuestionContainerRuntimeException(e);
        }
        return htmlPath;
    }

    private String getSpacesPath(String componentId) {
        StringBuilder spacesPath = new StringBuilder();
        List spaces = this.getOrganisationController().getPathToComponent(componentId);
        for (SpaceInstLight spaceInst : spaces) {
            spacesPath.append(spaceInst.getName());
            spacesPath.append(" > ");
        }
        return spacesPath.toString();
    }

    private String getComponentLabel(String componentId) {
        ComponentInstLight component = this.getOrganisationController().getComponentInstLight(componentId);
        String componentLabel = "";
        if (component != null) {
            componentLabel = component.getLabel();
        }
        return componentLabel;
    }

    private OrganizationController getOrganisationController() {
        return OrganizationControllerProvider.getOrganisationController();
    }

    @Transactional
    public void delete(String componentInstanceId) {
        try (Connection connection = DBUtil.openConnection();){
            AnswerDAO.deleteAnswersToAllQuestions(connection, componentInstanceId);
            QuestionResultDAO.setDeleteAllQuestionResultsByInstanceId(connection, componentInstanceId);
            ScoreDAO.deleteAllScoresByInstanceId(connection, componentInstanceId);
            QuestionDAO.deleteAllQuestionsByInstanceId(connection, componentInstanceId);
            QuestionContainerDAO.deleteAllQuestionContainersByInstanceId(connection, componentInstanceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }
}

