/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.answer.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.questioncontainer.answer.model.AnswerPK;

public class Answer
implements Serializable {
    private static final long serialVersionUID = 7915608110782813687L;
    private int nbPoints = 0;
    private boolean isSolution = false;
    private boolean isOpened = false;
    private int nbVoters = 0;
    private String image = null;
    private AnswerPK pk = null;
    private ResourceReference questionPK = null;
    private String label = null;
    private String comment = null;
    private String questionLink;

    public Answer(AnswerPK pk, ResourceReference questionPK, String label, int nbPointsPos, int nbPointsNeg, boolean isSolution, String comment, int nbVoters, boolean isOpened, String image) {
        this.questionPK = questionPK;
        this.label = label;
        this.nbVoters = nbVoters;
        this.pk = pk;
        this.isSolution = isSolution;
        this.comment = comment;
        this.isOpened = isOpened;
        this.image = image;
    }

    public Answer(AnswerPK pk, ResourceReference questionPK, String label, int nbPoints, boolean isSolution, String comment, int nbVoters, boolean isOpened, String image, String questionLink) {
        this.questionPK = questionPK;
        this.label = label;
        this.nbVoters = nbVoters;
        this.pk = pk;
        this.isSolution = isSolution;
        this.comment = comment;
        this.isOpened = isOpened;
        this.image = image;
        this.questionLink = questionLink;
        this.nbPoints = nbPoints;
    }

    public Answer(AnswerPK pk, ResourceReference questionPK, String label, String comment, int nbVoters, boolean isOpened, String image, String questionLink) {
        this(pk, questionPK, label, 0, false, comment, nbVoters, isOpened, image, questionLink);
    }

    public void setPK(AnswerPK pk) {
        this.pk = pk;
    }

    public void setQuestionPK(ResourceReference questionPK) {
        this.questionPK = questionPK;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setNbVoters(int nbVoters) {
        this.nbVoters = nbVoters;
    }

    public void setNbPoints(int nbPoints) {
        this.nbPoints = nbPoints;
    }

    public void setIsSolution(boolean isSolution) {
        this.isSolution = isSolution;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setIsOpened(boolean isOpened) {
        this.isOpened = isOpened;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setQuestionLink(String questionLink) {
        this.questionLink = questionLink;
    }

    public AnswerPK getPK() {
        return this.pk;
    }

    public ResourceReference getQuestionPK() {
        return this.questionPK;
    }

    public String getLabel() {
        return this.label;
    }

    public int getNbVoters() {
        return this.nbVoters;
    }

    public int getNbPoints() {
        return this.nbPoints;
    }

    public boolean isSolution() {
        return this.isSolution;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public String getImage() {
        return this.image;
    }

    public String getQuestionLink() {
        return this.questionLink;
    }

    public BigDecimal getPercent(int nbParticipants) {
        return new BigDecimal(this.getNbVoters()).multiply(new BigDecimal(100)).divide(new BigDecimal(nbParticipants), 2, RoundingMode.HALF_DOWN);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Answer {\n");
        result.append("  getQuestionPK() = " + this.getQuestionPK() + "\n");
        result.append("  getLabel() = " + this.getLabel() + "\n");
        result.append("  getNbVoters() = " + this.getNbVoters() + "\n");
        result.append("  getPK() = " + this.getPK() + "\n");
        result.append("  getNbPoints() = " + this.getNbPoints() + "\n");
        result.append("  isSolution() = " + this.isSolution() + "\n");
        result.append("  getComment() = " + this.getComment() + "\n");
        result.append("  isOpened() = " + this.isOpened() + "\n");
        result.append("  getQuestionLink() = " + this.getQuestionLink() + "\n");
        result.append("}");
        return result.toString();
    }
}

