/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import java.util.Objects;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;
import org.jetbrains.annotations.NotNull;

public final class GCGeneration {
    public static final GCGeneration NULL = new GCGeneration(0, 0, false);
    private final int generation;
    private final int fullGeneration;
    private final boolean isCompacted;

    public static GCGeneration newGCGeneration(int generation, int fullGeneration, boolean isCompacted) {
        return new GCGeneration(generation, fullGeneration, isCompacted);
    }

    public static GCGeneration newGCGeneration(SegmentArchiveEntry indexEntry) {
        return new GCGeneration(indexEntry.getGeneration(), indexEntry.getFullGeneration(), indexEntry.isCompacted());
    }

    private GCGeneration(int generation, int fullGeneration, boolean isCompacted) {
        this.generation = generation;
        this.fullGeneration = fullGeneration;
        this.isCompacted = isCompacted;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getFullGeneration() {
        return this.fullGeneration;
    }

    public boolean isCompacted() {
        return this.isCompacted;
    }

    @NotNull
    public GCGeneration nextFull() {
        return new GCGeneration(this.generation + 1, this.fullGeneration + 1, true);
    }

    @NotNull
    public GCGeneration nextTail() {
        return new GCGeneration(this.generation + 1, this.fullGeneration, true);
    }

    @NotNull
    public GCGeneration nextPartial() {
        return new GCGeneration(this.generation, this.fullGeneration, true);
    }

    @NotNull
    public GCGeneration nonGC() {
        return new GCGeneration(this.generation, this.fullGeneration, false);
    }

    public int compareWith(@NotNull GCGeneration gcGeneration) {
        return this.generation - Objects.requireNonNull(gcGeneration).generation;
    }

    public int compareFullGenerationWith(@NotNull GCGeneration gcGeneration) {
        return this.fullGeneration - Objects.requireNonNull(gcGeneration).fullGeneration;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GCGeneration that = (GCGeneration)other;
        return this.generation == that.generation && this.fullGeneration == that.fullGeneration && this.isCompacted == that.isCompacted;
    }

    public int hashCode() {
        return Objects.hash(this.generation, this.fullGeneration, this.isCompacted);
    }

    public String toString() {
        return "GCGeneration{generation=" + this.generation + ", fullGeneration=" + this.fullGeneration + ", isCompacted=" + this.isCompacted + "}";
    }
}

