/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;

public class LocalGCJournalFile
implements GCJournalFile {
    private final File file;

    public LocalGCJournalFile(File parent, String name) {
        this(new File(parent, name));
    }

    public LocalGCJournalFile(File file) {
        this.file = file;
    }

    @Override
    public void writeLine(String line) throws IOException {
        try (BufferedWriter w = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.DSYNC);){
            w.write(line);
            w.newLine();
        }
    }

    @Override
    public List<String> readLines() throws IOException {
        if (this.file.exists()) {
            return Files.readAllLines(this.file.toPath(), StandardCharsets.UTF_8);
        }
        return new ArrayList<String>();
    }

    @Override
    public void truncate() throws IOException {
        this.file.delete();
    }
}

