/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.data.RecordIdData;
import org.apache.jackrabbit.oak.segment.data.SegmentDataLoader;
import org.apache.jackrabbit.oak.segment.data.StringData;

public interface SegmentData {
    public static final int MAX_SMALL_LENGTH_VALUE = 128;
    public static final int MAX_MEDIUM_LENGTH_VALUE = 16512;

    public static SegmentData newSegmentData(Buffer buffer) {
        return SegmentDataLoader.newSegmentData(buffer);
    }

    public static SegmentData newRawSegmentData(Buffer buffer) {
        return SegmentDataLoader.newRawSegmentData(buffer);
    }

    public byte getVersion();

    public String getSignature();

    public int getFullGeneration();

    public boolean isCompacted();

    public int getGeneration();

    public int getSegmentReferencesCount();

    public int getRecordReferencesCount();

    public int getRecordReferenceNumber(int var1);

    public byte getRecordReferenceType(int var1);

    public int getRecordReferenceOffset(int var1);

    public long getSegmentReferenceMsb(int var1);

    public long getSegmentReferenceLsb(int var1);

    default public long readLength(int recordReferenceOffset) {
        int head = this.readByte(recordReferenceOffset) & 0xFF;
        if ((head & 0x80) == 0) {
            return head;
        }
        if ((head & 0x40) == 0) {
            return 128 + (this.readShort(recordReferenceOffset) & 0x3FFF);
        }
        return 16512L + (this.readLong(recordReferenceOffset) & 0x3FFFFFFFFFFFFFFFL);
    }

    default public StringData readString(int recordReferenceOffset) {
        long length = this.readLength(recordReferenceOffset);
        if (length >= Integer.MAX_VALUE) {
            throw new IllegalStateException("String is too long: " + length + "; possibly trying to read a BLOB using getString; can not convert BLOB to String");
        }
        if (length >= 16512L) {
            return new StringData(this.readRecordId(recordReferenceOffset + 8), (int)length);
        }
        int index = length >= 128L ? recordReferenceOffset + 2 : recordReferenceOffset + 1;
        Buffer buffer = this.readBytes(index, (int)length);
        String string = buffer.decode(StandardCharsets.UTF_8).toString();
        return new StringData(string, (int)length);
    }

    default public RecordIdData readRecordId(int recordReferenceOffset) {
        int segmentReference = this.readShort(recordReferenceOffset) & 0xFFFF;
        int recordNumber = this.readInt(recordReferenceOffset + 2);
        return new RecordIdData(segmentReference, recordNumber);
    }

    public byte readByte(int var1);

    public int readInt(int var1);

    public short readShort(int var1);

    public long readLong(int var1);

    public Buffer readBytes(int var1, int var2);

    public int size();

    public void hexDump(OutputStream var1) throws IOException;

    public void binDump(OutputStream var1) throws IOException;

    public int estimateMemoryUsage();
}

