/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.invitation;

import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.socialnetwork.invitation.AbstractInvitationUserNotification;
import org.silverpeas.core.socialnetwork.invitation.Invitation;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.URLUtil;

public class NewInvitationUserNotification
extends AbstractInvitationUserNotification {
    public NewInvitationUserNotification(Invitation invitation) {
        super(invitation);
    }

    @Override
    protected void performTemplateData(String language, Invitation resource, SilverpeasTemplate template) {
        UserFull sender = UserFull.getById(String.valueOf(resource.getSenderId()));
        template.setAttribute("senderUser", (Object)sender);
        template.setAttribute("userName", (Object)sender.getDisplayedName());
        template.setAttribute("senderMessage", (Object)Encode.forHtml((String)resource.getMessage()));
    }

    @Override
    protected void performNotificationResource(String language, Invitation resource, NotificationResourceData notificationResourceData) {
        String url = URLUtil.getURL("MyProfile", null, null) + "MyInvitations";
        this.getNotificationMetaData().setLink(url);
        this.getNotificationMetaData().setOriginalExtraMessage(resource.getMessage());
    }

    @Override
    protected NotifAction getAction() {
        return NotifAction.PENDING_VALIDATION;
    }

    @Override
    protected String getContributionAccessLinkLabelBundleKey() {
        return "myProfile.invitations.notification.notifLinkLabel";
    }
}

