/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork;

import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.notification.UserEvent;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.socialnetwork.invitation.InvitationService;
import org.silverpeas.core.socialnetwork.relationship.RelationShip;
import org.silverpeas.core.socialnetwork.relationship.RelationShipService;
import org.silverpeas.core.socialnetwork.service.SocialNetworkService;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class SocialNetworkUserListener
extends CDIResourceEventListener<UserEvent> {
    @Inject
    private SocialNetworkService socialNetworkService;
    @Inject
    private InvitationService invitationService;
    @Inject
    private RelationShipService relationShipService;

    public void onDeletion(UserEvent event) {
        UserDetail user = (UserDetail)((Object)event.getTransition().getBefore());
        SilverLogger.getLogger((Object)((Object)this)).debug("Delete all the social network data of user {0}", new Object[]{user.getId()});
        List<RelationShip> relationShips = this.relationShipService.getAllMyRelationShips(Integer.parseInt(user.getId()));
        relationShips.forEach(relationShip -> this.relationShipService.removeRelationShip(relationShip.getUser1Id(), relationShip.getUser2Id()));
        this.invitationService.deleteAllMyInvitations(user.getId());
        this.socialNetworkService.removeAllExternalAccount(user.getId());
    }
}

