/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.verifier;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.security.authentication.AuthenticationResponse;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordAboutToExpireException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordExpired;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordMustBeChangedOnFirstLogin;
import org.silverpeas.core.security.authentication.verifier.AbstractAuthenticationVerifier;
import org.silverpeas.kernel.util.StringUtil;

public class UserMustChangePasswordVerifier
extends AbstractAuthenticationVerifier {
    private static final Map<String, UserFirstLoginStep> usersFirstLoginStep = new ConcurrentHashMap<String, UserFirstLoginStep>();
    protected static boolean isThatUserMustChangePasswordOnFirstLogin = false;
    protected static boolean isThatUserMustFillEmailAddressOnFirstLogin = false;
    protected static boolean isMaxConnectionActivated = false;
    protected static boolean isOffsetConnectionActivated = false;
    protected static int nbMaxConnectionsForForcing = 0;
    protected static int nbMaxConnectionsForProposing = 0;

    protected static void setup(boolean userMustChangePasswordOnFirstLogin, boolean userMustFillEmailAddressOnFirstLogin, int nbSuccessfulUserConnectionsBeforeForcingPasswordChange, int nbSuccessfulUserConnectionsBeforeProposingToChangePassword) {
        isThatUserMustChangePasswordOnFirstLogin = false;
        isThatUserMustFillEmailAddressOnFirstLogin = false;
        isMaxConnectionActivated = false;
        isOffsetConnectionActivated = false;
        nbMaxConnectionsForForcing = 0;
        nbMaxConnectionsForProposing = 0;
        usersFirstLoginStep.clear();
        isThatUserMustChangePasswordOnFirstLogin = userMustChangePasswordOnFirstLogin;
        isThatUserMustFillEmailAddressOnFirstLogin = userMustFillEmailAddressOnFirstLogin;
        nbMaxConnectionsForForcing = nbSuccessfulUserConnectionsBeforeForcingPasswordChange;
        if (nbMaxConnectionsForForcing > 0) {
            isMaxConnectionActivated = true;
            nbMaxConnectionsForProposing = nbSuccessfulUserConnectionsBeforeProposingToChangePassword;
            if (nbMaxConnectionsForProposing > 0) {
                isOffsetConnectionActivated = true;
            }
        }
    }

    protected UserMustChangePasswordVerifier(User user) {
        super(user);
    }

    public String getDestinationOnFirstLogin(HttpServletRequest request) {
        AuthenticationResponse.Status error;
        AuthenticationResponse.Status status = error = isThatUserMustFillEmailAddressOnFirstLogin ? AuthenticationResponse.Status.PASSWORD_EMAIL_TO_CHANGE_ON_FIRST_LOGIN : AuthenticationResponse.Status.PASSWORD_TO_CHANGE_ON_FIRST_LOGIN;
        if (request != null) {
            String language = this.getUser() != null && StringUtil.isDefined((String)this.getUser().getId()) ? this.getUser().getUserPreferences().getLanguage() : I18NHelper.DEFAULT_LANGUAGE;
            String message = error.getMessage(language);
            request.setAttribute("message", (Object)message);
            request.setAttribute("isThatUserMustFillEmailAddressOnFirstLogin", (Object)isThatUserMustFillEmailAddressOnFirstLogin);
            if (isThatUserMustFillEmailAddressOnFirstLogin && this.getUser() != null) {
                request.setAttribute("emailAddress", (Object)this.getUser().getEmailAddress());
            }
        }
        return otherSettings.getString("passwordChangeOnFirstLoginURL") + "?ErrorCode=" + error;
    }

    public void verify() throws AuthenticationException {
        if (this.mustForceUserToChangePasswordOnFirstLogin()) {
            throw new AuthenticationPasswordMustBeChangedOnFirstLogin((String)(this.getUser() != null ? "Login=" + this.getUser().getLogin() : ""), new String[0]);
        }
        if (this.proposeToUserToChangePassword()) {
            throw new AuthenticationPasswordAboutToExpireException("The password has to be changed for the user with login " + this.getUser().getLogin(), new String[0]);
        }
        if (this.mustForceUserToChangePassword()) {
            throw new AuthenticationPasswordExpired((String)(this.getUser() != null ? "Login=" + this.getUser().getLogin() : ""), new String[0]);
        }
    }

    public void notifyPasswordChange() {
        if (isThatUserMustChangePasswordOnFirstLogin && this.getUser() != null) {
            usersFirstLoginStep.put(this.getUser().getId(), UserFirstLoginStep.PASSWORD_CHANGED);
        }
    }

    private boolean mustForceUserToChangePasswordOnFirstLogin() {
        boolean mustForceUserToChangePasswordOnFirstLogin = false;
        UserDetail user = (UserDetail)this.getUser();
        if (isThatUserMustChangePasswordOnFirstLogin && user != null && !user.isAnonymous()) {
            if (UserFirstLoginStep.PASSWORD_CHANGED.equals((Object)usersFirstLoginStep.get(user.getId()))) {
                usersFirstLoginStep.remove(user.getId());
            } else if (user.getLastLoginDate() == null || UserFirstLoginStep.CHANGE_PASSWORD.equals((Object)usersFirstLoginStep.get(user.getId()))) {
                usersFirstLoginStep.put(user.getId(), UserFirstLoginStep.CHANGE_PASSWORD);
                mustForceUserToChangePasswordOnFirstLogin = true;
            }
        }
        return mustForceUserToChangePasswordOnFirstLogin;
    }

    private boolean mustForceUserToChangePassword() {
        UserDetail user = (UserDetail)this.getUser();
        return isMaxConnectionActivated && user != null && !user.isAnonymous() && user.getNbSuccessfulLoginAttempts() != 0 && user.getNbSuccessfulLoginAttempts() >= nbMaxConnectionsForForcing;
    }

    private boolean proposeToUserToChangePassword() {
        UserDetail user = (UserDetail)this.getUser();
        return isMaxConnectionActivated && isOffsetConnectionActivated && user != null && !user.isAnonymous() && user.getNbSuccessfulLoginAttempts() != 0 && !this.mustForceUserToChangePassword() && user.getNbSuccessfulLoginAttempts() >= nbMaxConnectionsForProposing;
    }

    static {
        UserMustChangePasswordVerifier.setup(settings.getBoolean("userMustChangePasswordOnFirstLogin", false), settings.getBoolean("userMustFillEmailAddressOnFirstLogin", false), settings.getInteger("nbSuccessfulUserConnectionsBeforeForcingPasswordChange", 0), settings.getInteger("nbSuccessfulUserConnectionsBeforeProposingToChangePassword", 0));
    }

    private static enum UserFirstLoginStep {
        CHANGE_PASSWORD,
        PASSWORD_CHANGED;

    }
}

