/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.verifier;

import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.security.authentication.AuthenticationResponse;
import org.silverpeas.core.security.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.exception.AuthenticationUserAccountBlockedException;
import org.silverpeas.core.security.authentication.exception.AuthenticationUserAccountDeactivatedException;
import org.silverpeas.core.security.authentication.verifier.AbstractAuthenticationVerifier;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class UserCanLoginVerifier
extends AbstractAuthenticationVerifier {
    protected UserCanLoginVerifier(User user) {
        super(user);
    }

    public String getErrorDestination() {
        Object errorDest = "/Login?ErrorCode=";
        Domain[] tabDomains = null;
        try {
            tabDomains = Administration.get().getAllDomains();
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
        }
        if (this.getUser() == null || StringUtil.isNotDefined((String)this.getUser().getId())) {
            errorDest = tabDomains != null && tabDomains.length > 1 ? (String)errorDest + AuthenticationResponse.Status.BAD_LOGIN_PASSWORD_DOMAIN : (String)errorDest + AuthenticationResponse.Status.BAD_LOGIN_PASSWORD;
        } else if (this.isUserStateNotValid()) {
            errorDest = this.getUser().isDeactivatedState() ? (String)errorDest + AuthenticationResponse.Status.USER_ACCOUNT_DEACTIVATED : (String)errorDest + AuthenticationResponse.Status.USER_ACCOUNT_BLOCKED;
        }
        return errorDest;
    }

    public void verify() throws AuthenticationException {
        if (this.getUser() == null) {
            throw new AuthenticationBadCredentialException("No user with such credential", new String[0]);
        }
        if (this.isUserStateNotValid()) {
            if (this.getUser().isDeactivatedState()) {
                throw new AuthenticationUserAccountDeactivatedException("The account of the user with login " + this.getUser().getLogin() + " is deactivated", new String[0]);
            }
            throw new AuthenticationUserAccountBlockedException("The account of the user with login " + this.getUser().getLogin() + " is blocked", new String[0]);
        }
    }

    private boolean isUserStateNotValid() {
        return this.getUser() == null || !this.getUser().isValidState();
    }
}

