/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.htmlparser.jericho.Source;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionLocalizationBundle;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.notification.user.FallbackToCoreTemplatePathBehavior;
import org.silverpeas.core.notification.user.builder.AbstractContributionTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.reminder.DateTimeReminder;
import org.silverpeas.core.reminder.DurationReminder;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.ReminderSettings;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.filter.FilterByType;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

public class DefaultContributionReminderUserNotification
extends AbstractContributionTemplateUserNotificationBuilder<Contribution>
implements FallbackToCoreTemplatePathBehavior {
    private final Reminder reminder;
    private final User receiver;
    private final ZoneId userZoneId;
    private final Supplier<IllegalArgumentException> notHandledReminderType;
    private final Temporal reminderContributionStart;
    private final Temporal reminderContributionEnd;
    private final String zoneIdIfDifferentToContribution;

    protected DefaultContributionReminderUserNotification(Reminder reminder) {
        super(reminder.getContribution());
        this.reminder = reminder;
        this.receiver = User.getById((String)reminder.getUserId());
        this.userZoneId = this.receiver.getUserPreferences().getZoneId();
        this.notHandledReminderType = () -> new IllegalArgumentException("Reminder type " + this.reminder.getClass() + " is not handled");
        this.reminderContributionStart = this.computeReminderContributionStart();
        this.reminderContributionEnd = this.computeReminderContributionEnd();
        this.zoneIdIfDifferentToContribution = this.computeZoneIdIfDifferentToContribution();
    }

    protected Temporal computeReminderContributionStart() {
        return this.normalizeTemporal(this.getScheduledDateTimeWithZeroDuration());
    }

    private Temporal getReminderContributionStart() {
        return this.reminderContributionStart;
    }

    protected Temporal computeReminderContributionEnd() {
        return null;
    }

    private Temporal getReminderContributionEnd() {
        return this.reminderContributionEnd;
    }

    private String computeZoneIdIfDifferentToContribution() {
        if (!this.getZoneIdForNormalization().equals(this.userZoneId)) {
            return this.getZoneIdForNormalization().getId();
        }
        return null;
    }

    private boolean isReminderContributionOnSeveralDays() {
        return this.getReminderContributionEnd() != null && (this.getReminderContributionStart().get(ChronoField.YEAR) != this.getReminderContributionEnd().get(ChronoField.YEAR) || this.getReminderContributionStart().get(ChronoField.MONTH_OF_YEAR) != this.getReminderContributionEnd().get(ChronoField.MONTH_OF_YEAR) || this.getReminderContributionStart().get(ChronoField.DAY_OF_MONTH) != this.getReminderContributionEnd().get(ChronoField.DAY_OF_MONTH));
    }

    protected Temporal getScheduledDateTimeWithZeroDuration() {
        return (Temporal)new FilterByType((Object)this.reminder).matchFirst(DurationReminder.class::equals, r -> {
            DurationReminder durationReminder = (DurationReminder)r;
            return durationReminder.getScheduledDateTime().plus(durationReminder.getDuration(), durationReminder.getTimeUnit().toChronoUnit());
        }).matchFirst(DateTimeReminder.class::equals, r -> {
            DateTimeReminder dateTimeReminder = (DateTimeReminder)r;
            return dateTimeReminder.getScheduledDateTime();
        }).result().orElseThrow(this.notHandledReminderType);
    }

    protected ZoneId getZoneIdForNormalization() {
        return ZoneId.systemDefault();
    }

    protected Temporal normalizeTemporal(Temporal temporal) {
        return (Temporal)new FilterByType((Object)temporal).matchFirst(LocalDate.class::equals, Temporal.class::cast).matchFirst(OffsetDateTime.class::equals, d -> ((OffsetDateTime)d).atZoneSameInstant(this.getZoneIdForNormalization())).matchFirst(ZonedDateTime.class::equals, d -> ((ZonedDateTime)d).withZoneSameInstant(this.getZoneIdForNormalization())).result().orElseThrow(() -> new SilverpeasRuntimeException("not handled type"));
    }

    @Override
    protected String getBundleSubjectKey() {
        return null;
    }

    @Override
    protected void performTemplateData(LocalizedContribution localizedContribution, SilverpeasTemplate template) {
        super.performTemplateData(localizedContribution, template);
        String language = localizedContribution.getLanguage();
        AbstractTemplateUserNotificationBuilder.NotificationTemporal start = new AbstractTemplateUserNotificationBuilder.NotificationTemporal(this.reminderContributionStart, this.userZoneId, language);
        AbstractTemplateUserNotificationBuilder.NotificationTemporal end = new AbstractTemplateUserNotificationBuilder.NotificationTemporal(this.reminderContributionEnd, this.userZoneId, language);
        String reminderTitle = new FilterByType((Object)this.reminder).matchFirst(DurationReminder.class::equals, r -> {
            DurationReminder durationReminder = (DurationReminder)r;
            return this.getUnitBundle(language).getStringWithParams(durationReminder.getTimeUnit() + ".precise", new Object[]{durationReminder.getDuration()});
        }).result().orElse("");
        String contributionTitle = (String)new FilterByType((Object)this.reminder).matchFirst(DurationReminder.class::equals, r -> {
            DurationReminder durationReminder = (DurationReminder)r;
            return ContributionLocalizationBundle.getByInstanceAndLanguage((Contribution)((Contribution)this.getResource()), (String)language).getUiMessageTitleByTypeAndProperty(durationReminder.getContributionProperty());
        }).matchFirst(DateTimeReminder.class::equals, r -> ContributionLocalizationBundle.getByInstanceAndLanguage((Contribution)((Contribution)this.getResource()), (String)language).getUiMessageTitleByType()).result().orElseThrow(this.notHandledReminderType);
        String contributionTitleText = new Source((CharSequence)contributionTitle).getTextExtractor().toString();
        template.setAttribute("reminderTitle", (Object)reminderTitle);
        template.setAttribute("contributionTitle", (Object)contributionTitle);
        template.setAttribute("reminderContributionStart", (Object)start);
        template.setAttribute("reminderContributionEnd", (Object)end);
        template.setAttribute("reminderContributionSeveralDays", (Object)this.isReminderContributionOnSeveralDays());
        template.setAttribute("reminderContributionZoneId", (Object)this.zoneIdIfDifferentToContribution);
        this.getNotificationMetaData().addLanguage(language, ReminderSettings.getMessagesIn((String)language).getStringWithParams("reminder.on", new Object[]{contributionTitleText, this.formatTemporalDataOfNotificationTitle(start, end)}), null);
    }

    private String formatTemporalDataOfNotificationTitle(AbstractTemplateUserNotificationBuilder.NotificationTemporal start, AbstractTemplateUserNotificationBuilder.NotificationTemporal end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start.getDate());
        if (end.isDateExisting()) {
            if (this.isReminderContributionOnSeveralDays()) {
                sb.append(" - ");
                sb.append(end.getDate());
            } else if (end.isTimeExisting()) {
                sb.append(" - ");
                sb.append(end.getDayTime());
            }
        }
        if (StringUtil.isDefined((String)this.zoneIdIfDifferentToContribution)) {
            sb.append(" (").append(this.zoneIdIfDifferentToContribution).append(")");
        }
        return sb.toString();
    }

    @Override
    protected String getTemplateFileName() {
        return (String)new FilterByType((Object)this.reminder).matchFirst(DurationReminder.class::equals, r -> "reminder-duration").matchFirst(DateTimeReminder.class::equals, r -> "reminder-datetime").result().orElseThrow(this.notHandledReminderType);
    }

    @Override
    protected String getTemplatePath() {
        return "reminder";
    }

    @Override
    protected NotifAction getAction() {
        return NotifAction.REPORT;
    }

    @Override
    protected String getSender() {
        return "";
    }

    @Override
    protected Collection<String> getUserIdsToNotify() {
        return Collections.singleton(this.receiver.getId());
    }

    @Override
    protected boolean isSendImmediately() {
        return true;
    }

    private LocalizationBundle getUnitBundle(String language) {
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.multilang.util", (String)language);
    }
}

