/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.process.annotation;

import java.util.List;
import java.util.Map;
import org.silverpeas.core.ActionType;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.process.annotation.DummyHandledFileConverter;
import org.silverpeas.core.process.annotation.DummyHandledFileConverterRegistration;
import org.silverpeas.core.process.annotation.SimulationElement;
import org.silverpeas.core.process.io.file.DummyHandledFile;
import org.silverpeas.core.process.io.file.FileHandler;
import org.silverpeas.core.process.management.AbstractFileProcess;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.ProcessSession;

public class SimulationElementConversionProcess
extends AbstractFileProcess<ProcessExecutionContext> {
    private final Map<Class<SimulationElement<?>>, List<SimulationElement<?>>> elements;
    final ResourceReference target;
    final ActionType actionType;

    SimulationElementConversionProcess(Map<Class<SimulationElement<?>>, List<SimulationElement<?>>> elements, ResourceReference target, ActionType actionType) {
        this.elements = elements;
        this.target = target;
        this.actionType = actionType;
    }

    @Override
    public void processFiles(ProcessExecutionContext processExecutionContext, ProcessSession session, FileHandler fileHandler) throws Exception {
        for (Map.Entry<Class<SimulationElement<?>>, List<SimulationElement<?>>> typeElements : this.elements.entrySet()) {
            DummyHandledFileConverter<SimulationElement<?>> converter = DummyHandledFileConverterRegistration.getConverter(typeElements.getKey());
            if (converter == null) {
                throw new AssertionError((Object)"SimulationElementConversionProcess.processFiles : converter is null (converter must exist for a type of element)");
            }
            List<DummyHandledFile> handledFiles = converter.convert(typeElements.getValue(), this.target, this.actionType);
            for (DummyHandledFile dummyHandledFile : handledFiles) {
                fileHandler.addDummyHandledFile(dummyHandledFile);
            }
        }
    }
}

