/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.xml;

import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationTag;
import org.silverpeas.core.notification.user.server.xml.TargetNameContentHandler;
import org.silverpeas.core.notification.user.server.xml.TargetParamContentHandler;
import org.silverpeas.core.notification.user.server.xml.TargetReceiptContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TargetContentHandler
extends DefaultHandler {
    private final NotificationData data;
    private final ContentHandler parent;
    private final XMLReader parser;

    public TargetContentHandler(NotificationData data, ContentHandler parent, XMLReader parser) {
        this.data = data;
        this.parent = parent;
        this.parser = parser;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        DefaultHandler child;
        NotificationTag tag = NotificationTag.valueOf(qName);
        switch (tag) {
            case TARGET: {
                child = null;
                this.data.setTargetChannel(attributes.getValue(NotificationTag.CHANNEL.toString()));
                break;
            }
            case NAME: {
                child = new TargetNameContentHandler(this.data, this, this.parser);
                this.parser.setContentHandler(child);
                break;
            }
            case RECEIPT: {
                child = new TargetReceiptContentHandler(this.data, this, this.parser);
                this.parser.setContentHandler(child);
                break;
            }
            case PARAM: {
                child = new TargetParamContentHandler(this.data, this, this.parser);
                this.parser.setContentHandler(child);
                break;
            }
            default: {
                child = null;
            }
        }
        if (child != null) {
            this.parser.setContentHandler(child);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        NotificationTag tag = NotificationTag.valueOf(qName);
        if (tag == NotificationTag.TARGET) {
            this.parser.setContentHandler(this.parent);
        }
    }
}

