/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.builder;

import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.contribution.model.SilverpeasToolContent;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.notification.user.DefaultUserNotification;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.notification.user.builder.AbstractUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.util.Link;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMapProvider;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMapProviderByInstance;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractResourceUserNotificationBuilder<T>
extends AbstractUserNotificationBuilder {
    private T resource;

    private AbstractResourceUserNotificationBuilder(T resource, String title, String content) {
        super(title, content);
        this.setResource(resource);
    }

    public AbstractResourceUserNotificationBuilder(T resource) {
        this(resource, null, null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        String link = this.getResourceURL(this.resource);
        this.getNotificationMetaData().setLink(link);
    }

    @Override
    protected boolean isUserCanBeNotified(String userId) {
        boolean isAccessible;
        if (this.resource instanceof NodeDetail) {
            NodeDetail node = (NodeDetail)this.resource;
            isAccessible = NodeAccessControl.get().isUserAuthorized(userId, node);
        } else if (this.resource instanceof Contribution) {
            Contribution contribution = (Contribution)this.resource;
            String instanceId = contribution.getIdentifier().getComponentInstanceId();
            isAccessible = ComponentAccessControl.get().isUserAuthorized(userId, (Object)instanceId);
        } else {
            String instanceId = this.getComponentInstanceId();
            isAccessible = StringUtil.isDefined((String)instanceId) ? ComponentAccessControl.get().isUserAuthorized(userId, (Object)instanceId) : true;
        }
        return isAccessible;
    }

    @Override
    protected boolean isGroupCanBeNotified(String groupId) {
        boolean isAccessible;
        if (this.resource instanceof NodeDetail) {
            NodeDetail node = (NodeDetail)this.resource;
            isAccessible = NodeAccessControl.get().isGroupAuthorized(groupId, node.getNodePK());
        } else if (this.resource instanceof Contribution) {
            Contribution contribution = (Contribution)this.resource;
            String instanceId = contribution.getIdentifier().getComponentInstanceId();
            isAccessible = ComponentAccessControl.get().isGroupAuthorized(groupId, (Object)instanceId);
        } else {
            String instanceId = this.getComponentInstanceId();
            isAccessible = StringUtil.isDefined((String)instanceId) ? ComponentAccessControl.get().isGroupAuthorized(groupId, (Object)instanceId) : true;
        }
        return isAccessible;
    }

    @Override
    protected final void performBuild() {
        this.performBuild(this.resource);
        this.performNotificationResource(this.resource);
        if (this.getAction() == NotifAction.DELETE) {
            this.getNotificationMetaData().setLink(Link.EMPTY_LINK);
        }
    }

    @Override
    protected UserNotification createNotification() {
        return new DefaultUserNotification(this.getTitle(), this.getContent());
    }

    protected abstract void performBuild(T var1);

    protected void performNotificationResource(T resource) {
        NotificationResourceData notificationResourceData = this.initializeNotificationResourceData();
        this.performNotificationResource(resource, notificationResourceData);
        this.getNotificationMetaData().setNotificationResourceData(notificationResourceData);
    }

    protected NotificationResourceData initializeNotificationResourceData() {
        NotificationMetaData metaData = this.getNotificationMetaData();
        NotificationResourceData notificationResourceData = new NotificationResourceData();
        notificationResourceData.setComponentInstanceId(metaData.getComponentId());
        notificationResourceData.setResourceUrl(metaData.getLink().getLinkUrl());
        if (this.resource instanceof SilverpeasContent) {
            this.fill(notificationResourceData, (SilverpeasContent)this.resource);
        } else if (this.resource instanceof Contribution) {
            this.fill(notificationResourceData, (Contribution)this.resource);
        }
        return notificationResourceData;
    }

    protected abstract void performNotificationResource(T var1, NotificationResourceData var2);

    protected String getResourceURL(T resource) {
        String resourceUrl = null;
        if (resource instanceof SilverpeasContent) {
            resourceUrl = URLUtil.getSearchResultURL((SilverpeasContent)resource);
        } else if (resource instanceof Contribution) {
            Contribution contribution = (Contribution)resource;
            ComponentInstanceRoutingMapProvider routingMapProvider = ComponentInstanceRoutingMapProviderByInstance.get().getByInstanceId(contribution.getIdentifier().getComponentInstanceId());
            resourceUrl = routingMapProvider.absolute().getPermalink(contribution.getIdentifier()).toString();
        }
        if (StringUtils.isBlank((CharSequence)resourceUrl)) {
            resourceUrl = "";
        }
        return resourceUrl;
    }

    @Override
    protected boolean isSendImmediately() {
        return this.getResource() instanceof SilverpeasToolContent;
    }

    protected final T getResource() {
        return this.resource;
    }

    protected final void setResource(T resource) {
        this.resource = resource;
    }

    private void fill(NotificationResourceData notificationResourceData, SilverpeasContent silverpeasContent) {
        notificationResourceData.setResourceId(silverpeasContent.getId());
        notificationResourceData.setResourceType(silverpeasContent.getContributionType());
    }

    private void fill(NotificationResourceData notificationResourceData, Contribution contribution) {
        ContributionIdentifier contributionId = contribution.getIdentifier();
        notificationResourceData.setComponentInstanceId(contributionId.getComponentInstanceId());
        notificationResourceData.setResourceId(contributionId.getLocalId());
        notificationResourceData.setResourceType(contributionId.getType());
        notificationResourceData.setResourceName(contribution.getTitle());
        notificationResourceData.setResourceDescription(contribution.getDescription());
    }
}

