/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.IndexFileManager;
import org.silverpeas.core.index.indexing.IndexingLogger;
import org.silverpeas.core.index.indexing.model.DidYouMeanIndexer;
import org.silverpeas.core.index.indexing.model.DocumentIndexing;
import org.silverpeas.core.index.indexing.model.FieldDescription;
import org.silverpeas.core.index.indexing.model.FileDescription;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.index.indexing.model.IndexProcessor;
import org.silverpeas.core.index.indexing.model.TextDescription;
import org.silverpeas.core.index.indexing.model.WAAnalyzer;
import org.silverpeas.core.index.indexing.parser.Parser;
import org.silverpeas.core.index.indexing.parser.ParserManager;
import org.silverpeas.core.index.search.SearchEnginePropertiesManager;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Bean
@Singleton
public class IndexManager {
    public static final String ID = "id";
    public static final String KEY = "key";
    public static final String SCOPE = "scope";
    public static final String TITLE = "title";
    public static final String PREVIEW = "preview";
    public static final String KEYWORDS = "keywords";
    public static final String CREATIONDATE = "creationDate";
    public static final String CREATIONUSER = "creationUser";
    public static final String LASTUPDATEDATE = "updateDate";
    public static final String LASTUPDATEUSER = "updateUser";
    public static final String STARTDATE = "startDate";
    public static final String ENDDATE = "endDate";
    public static final String HEADER = "header";
    public static final String CONTENT = "content";
    public static final String THUMBNAIL = "thumbnail";
    public static final String THUMBNAIL_MIMETYPE = "thumbnailMimeType";
    public static final String THUMBNAIL_DIRECTORY = "thumbnailDirectory";
    public static final String SERVER_NAME = "serverName";
    public static final String EMBEDDED_FILE_IDS = "embeddedFileIds";
    public static final String FIELDS_FOR_FACETS = "fieldsForFacet";
    public static final String FILENAME = "filename";
    public static final String PATH = "path";
    public static final String ALIAS = "alias";
    public static final int NONE = -1;
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public static final int ADD_AGAIN = 2;
    private static final String ATTACHMENT_PREFIX = "Attachment";
    private static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    private static final int DEFAULT_MERGE_FACTOR_VALUE = 10;
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.index.indexing.IndexEngine");
    private static int maxFieldLength = 10000;
    private static int mergeFactor = 10;
    private static int maxMergeDocs = Integer.MAX_VALUE;
    private static final double DEFAULT_RAM_BUFFER_SIZE_MB;
    private static final boolean ENABLE_DYM_INDEXING;
    private static final String SILVERPEAS_SERVER_NAME;
    private final Map<String, IndexWriter> indexWriters = new LinkedHashMap<String, IndexWriter>();
    @Inject
    private ParserManager parserManager;

    private IndexManager() {
    }

    public static IndexManager get() {
        return (IndexManager)ServiceProvider.getService(IndexManager.class, (Annotation[])new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIndexEntry(FullIndexEntry indexEntry) {
        long start = System.currentTimeMillis();
        try {
            indexEntry.setServerName(SILVERPEAS_SERVER_NAME);
            String indexPath = this.getIndexDirectoryPath(indexEntry);
            IndexWriter writer = this.getIndexWriter(indexPath, indexEntry.getLang());
            this.removeIndexEntry(writer, indexEntry.getPK());
            this.index(writer, indexEntry);
        }
        finally {
            IndexingLogger.indexingLogger().debug(() -> MessageFormat.format("addIndexEntry {0} in {1}", indexEntry.getPK(), DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - start))));
        }
    }

    public void flush() {
        IndexProcessor.doFlush(() -> {
            SilverLogger logger = IndexingLogger.indexingLogger();
            ArrayList<String> pathProcessed = new ArrayList<String>(this.indexWriters.size());
            Iterator<Map.Entry<String, IndexWriter>> it = this.indexWriters.entrySet().iterator();
            logger.debug("flushing manager of indexation about {0} writer(s)", new Object[]{this.indexWriters.size()});
            while (it.hasNext()) {
                Map.Entry<String, IndexWriter> entry = it.next();
                String path = entry.getKey();
                IndexWriter writer = entry.getValue();
                pathProcessed.add(path);
                logger.debug("\t- closing writer of path {0}", new Object[]{path});
                try {
                    writer.close();
                }
                catch (IOException e) {
                    IndexingLogger.indexingLogger().error("Cannot close index " + path, (Throwable)e);
                }
                if (ENABLE_DYM_INDEXING) {
                    DidYouMeanIndexer.createSpellIndexForAllLanguage(CONTENT, path);
                }
                it.remove();
            }
            return pathProcessed;
        });
    }

    private void removeIndexEntry(IndexWriter writer, IndexEntryKey indexEntryKey) {
        Term term = new Term(KEY, indexEntryKey.toString());
        try {
            writer.deleteDocuments(new Term[]{term});
        }
        catch (IOException e) {
            IndexingLogger.indexingLogger().error("Index deletion failure: " + indexEntryKey, (Throwable)e);
        }
    }

    void removeIndexEntry(IndexEntryKey indexEntry) {
        String indexPath = this.getIndexDirectoryPath(indexEntry);
        IndexWriter writer = this.getIndexWriter(indexPath, "");
        if (writer != null) {
            this.removeIndexEntry(writer, indexEntry);
        }
    }

    private void removeIndexEntries(IndexWriter writer, String scope) {
        Term term = new Term(SCOPE, scope);
        try {
            writer.deleteDocuments(new Term[]{term});
        }
        catch (IOException e) {
            IndexingLogger.indexingLogger().error("Index deletion failure for scope : " + scope, (Throwable)e);
        }
    }

    void removeIndexEntries(String scope) {
        String indexPath = this.getIndexDirectoryPath(scope);
        IndexWriter writer = this.getIndexWriter(indexPath, "");
        if (writer != null) {
            this.removeIndexEntries(writer, scope);
        }
    }

    void removeAllIndexEntries() {
        IndexProcessor.doRemoveAll(() -> {
            this.flush();
            File indexRepository = Paths.get(IndexFileManager.getIndexUpLoadPath(), new String[0]).toFile();
            File savedIndexRepository = Paths.get(indexRepository.getAbsolutePath() + "_" + LocalDateTime.now().toString().replaceAll("[:']", ""), new String[0]).toFile();
            if (!indexRepository.renameTo(savedIndexRepository)) {
                throw new SilverpeasRuntimeException("index repository folder can not be renamed, please shutdown the server in order to rename it manually");
            }
        });
    }

    private String getIndexDirectoryPath(IndexEntry indexEntry) {
        return this.getIndexDirectoryPath(indexEntry.getPK());
    }

    private String getIndexDirectoryPath(IndexEntryKey indexEntry) {
        return this.getIndexDirectoryPath(indexEntry.getComponentId());
    }

    public String getIndexDirectoryPath(String component) {
        return IndexFileManager.getAbsoluteIndexPath(component);
    }

    public Analyzer getAnalyzer(String language) {
        Analyzer analyzer = WAAnalyzer.getAnalyzer(language);
        if (analyzer == null) {
            analyzer = new LimitTokenCountAnalyzer((Analyzer)new StandardAnalyzer(), maxFieldLength);
        }
        return analyzer;
    }

    private Optional<Reader> getReader(FileDescription file) {
        String filePath = file.getPath();
        return Optional.ofNullable(file.getFormat()).map(f -> this.hasMimetypeToBeIgnored(filePath, (String)f) ? null : f).flatMap(this.parserManager::getParser).map(p -> p.getContext(filePath, file.getEncoding())).filter(c -> c.getMetadata().getValue("Content-Type").map(t -> this.hasMimetypeToBeIgnored(filePath, (String)t)).filter(Boolean.TRUE::equals).isEmpty()).map(Parser.Context::getReader);
    }

    private boolean hasMimetypeToBeIgnored(String filePath, String mimeType) {
        String pattern = settings.getString("index.file.content.mimetype.ignore.pattern", "(?i).*(protected|encrypted).*");
        boolean hasToBeIgnored = mimeType.matches(pattern);
        if (hasToBeIgnored) {
            IndexingLogger.indexingLogger().warn("Mimetype {0} must be ignored, removing from indexation the content of file {1}", new Object[]{mimeType, filePath});
        }
        return hasToBeIgnored;
    }

    private IndexWriter getIndexWriter(String path, String language) {
        this.indexWriters.computeIfPresent(path, (s, w) -> w.isOpen() ? w : null);
        return this.indexWriters.computeIfAbsent(path, p -> {
            try {
                File file = new File(path);
                if (!file.exists()) {
                    file.mkdirs();
                }
                LogDocMergePolicy policy = new LogDocMergePolicy();
                policy.setMergeFactor(mergeFactor);
                policy.setMaxMergeDocs(maxMergeDocs);
                IndexWriterConfig configuration = new IndexWriterConfig(this.getAnalyzer(language)).setRAMBufferSizeMB(DEFAULT_RAM_BUFFER_SIZE_MB).setMergePolicy((MergePolicy)policy);
                return new IndexWriter((Directory)FSDirectory.open((Path)file.toPath()), configuration);
            }
            catch (IOException e) {
                IndexingLogger.indexingLogger().error("Unknown index file " + path, (Throwable)e);
                return null;
            }
        });
    }

    private void index(IndexWriter writer, FullIndexEntry indexEntry) {
        try {
            Term key = new Term(KEY, indexEntry.getPK().toString());
            writer.updateDocument(key, (Iterable)this.makeDocument(indexEntry));
        }
        catch (Exception e) {
            IndexingLogger.indexingLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    private Document makeDocument(FullIndexEntry indexEntry) {
        Document doc = new Document();
        if (StringUtil.isDefined((String)indexEntry.getObjectId())) {
            ServiceProvider.getAllServices(DocumentIndexing.class, (Annotation[])new Annotation[0]).forEach(documentIndexing -> documentIndexing.updateIndexEntryWithDocuments(indexEntry));
        }
        doc.add((IndexableField)new StringField(KEY, indexEntry.getPK().toString(), Field.Store.YES));
        doc.add((IndexableField)new StringField(SCOPE, indexEntry.getPK().getComponentId(), Field.Store.YES));
        this.setTitleField(indexEntry, doc);
        this.setPreviewAndKeyWordsField(indexEntry, doc);
        this.setCreationAndUpdateFields(indexEntry, doc);
        this.setThumbnailField(indexEntry, doc);
        this.setContentIdField(indexEntry, doc);
        this.setHeaderFields(indexEntry, doc);
        this.setContentFields(indexEntry, doc);
        this.setContentTextField(indexEntry, doc);
        this.setAlias(indexEntry, doc);
        this.setFileRelativeFields(indexEntry, doc);
        this.setAdditionalFields(indexEntry, doc);
        doc.add((IndexableField)new StringField(SERVER_NAME, indexEntry.getServerName(), Field.Store.YES));
        return doc;
    }

    private void setAlias(FullIndexEntry indexEntry, Document doc) {
        if (indexEntry.getPaths() != null) {
            for (String path : indexEntry.getPaths()) {
                doc.add((IndexableField)new StringField(PATH, path, Field.Store.YES));
            }
        }
        doc.add((IndexableField)new Field(ALIAS, (CharSequence)Boolean.toString(indexEntry.isAlias()), (IndexableFieldType)TextField.TYPE_STORED));
    }

    private void setAdditionalFields(FullIndexEntry indexEntry, Document doc) {
        List<FieldDescription> list3 = indexEntry.getFields();
        ArrayList<String> fieldsForFacets = new ArrayList<String>(list3.size());
        for (FieldDescription field : list3) {
            Field.Store storeAction;
            if (!StringUtil.isDefined((String)field.getContent())) continue;
            String fieldName = this.getFieldName(field.getFieldName(), field.getLang());
            if (field.isStored() || SearchEnginePropertiesManager.getFieldsNameList().contains(field.getFieldName())) {
                storeAction = Field.Store.YES;
                fieldsForFacets.add(fieldName);
            } else {
                storeAction = Field.Store.NO;
            }
            doc.add((IndexableField)new TextField(fieldName, field.getContent(), storeAction));
        }
        if (!fieldsForFacets.isEmpty()) {
            String stringForFacets = this.buildStringForFacets(fieldsForFacets);
            doc.add((IndexableField)new StringField(FIELDS_FOR_FACETS, stringForFacets, Field.Store.YES));
        }
    }

    private void setFileRelativeFields(FullIndexEntry indexEntry, Document doc) {
        List<FileDescription> list2 = indexEntry.getFileContentList();
        for (FileDescription fileDescription : list2) {
            this.addFile(doc, fileDescription);
        }
        List<FileDescription> linkedFiles = indexEntry.getLinkedFileContentList();
        for (FileDescription linkedFile : linkedFiles) {
            this.addFile(doc, linkedFile);
        }
        Set<String> set = indexEntry.getLinkedFileIdsSet();
        for (String linkedFileId : set) {
            doc.add((IndexableField)new StringField(EMBEDDED_FILE_IDS, linkedFileId, Field.Store.YES));
        }
    }

    private void setContentTextField(FullIndexEntry indexEntry, Document doc) {
        List<TextDescription> list1 = indexEntry.getTextContentList();
        for (TextDescription t : list1) {
            if (t == null || t.getContent() == null) continue;
            doc.add((IndexableField)new Field(this.getFieldName(CONTENT, t.getLang()), (CharSequence)t.getContent(), (IndexableFieldType)TextField.TYPE_NOT_STORED));
        }
    }

    private void setContentFields(FullIndexEntry indexEntry, Document doc) {
        if (indexEntry.getObjectType() != null && indexEntry.getObjectType().startsWith(ATTACHMENT_PREFIX)) {
            String lang = indexEntry.getLang();
            if (indexEntry.getTitle(lang) != null) {
                this.addToDocContent(indexEntry.getTitle(lang), doc, lang);
            }
            this.addToDocContent(indexEntry.getFilename(), doc, lang);
        } else {
            this.addToDocContent(indexEntry.getTitle(), doc);
        }
        Iterator<String> languages = indexEntry.getLanguages();
        while (languages.hasNext()) {
            String language = languages.next();
            if (indexEntry.getTitle(language) != null) {
                this.addToDocContent(indexEntry.getTitle(language), doc, language);
            }
            if (indexEntry.getPreview(language) != null) {
                this.addToDocContent(indexEntry.getPreview(language), doc, language);
            }
            if (indexEntry.getKeywords(language) == null) continue;
            this.addToDocContent(indexEntry.getKeywords(language), doc, language);
        }
    }

    private void addToDocContent(String value, Document doc) {
        this.addToDocContent(CONTENT, value, doc);
    }

    private void addToDocContent(String value, Document doc, String lang) {
        String fieldName = this.getFieldName(CONTENT, lang);
        this.addToDocContent(fieldName, value, doc);
    }

    private void addToDocContent(String fieldName, String value, Document doc) {
        doc.add((IndexableField)new Field(fieldName, (CharSequence)value, (IndexableFieldType)TextField.TYPE_NOT_STORED));
        doc.add((IndexableField)new Field(fieldName, (CharSequence)value.replaceAll("[_-]", " "), (IndexableFieldType)TextField.TYPE_NOT_STORED));
    }

    private void setHeaderFields(FullIndexEntry indexEntry, Document doc) {
        String language;
        Iterator<String> languages;
        if (indexEntry.getObjectType() != null && indexEntry.getObjectType().startsWith(ATTACHMENT_PREFIX)) {
            String lang = indexEntry.getLang();
            if (indexEntry.getTitle(lang) != null) {
                doc.add((IndexableField)new Field(this.getFieldName(HEADER, lang), (CharSequence)indexEntry.getTitle(lang), (IndexableFieldType)TextField.TYPE_NOT_STORED));
            }
            doc.add((IndexableField)new Field(this.getFieldName(HEADER, lang), (CharSequence)indexEntry.getFilename(), (IndexableFieldType)TextField.TYPE_NOT_STORED));
        } else {
            languages = indexEntry.getLanguages();
            while (languages.hasNext()) {
                language = languages.next();
                if (indexEntry.getTitle(language) == null) continue;
                doc.add((IndexableField)new Field(this.getFieldName(HEADER, language), (CharSequence)indexEntry.getTitle(language), (IndexableFieldType)TextField.TYPE_NOT_STORED));
            }
        }
        languages = indexEntry.getLanguages();
        while (languages.hasNext()) {
            language = languages.next();
            if (indexEntry.getKeywords(language) == null) continue;
            doc.add((IndexableField)new Field(this.getFieldName(HEADER, language), (CharSequence)indexEntry.getKeywords(language), (IndexableFieldType)TextField.TYPE_NOT_STORED));
        }
    }

    private void setContentIdField(FullIndexEntry indexEntry, Document doc) {
        if (indexEntry.isIndexId()) {
            doc.add((IndexableField)new Field(CONTENT, (CharSequence)indexEntry.getObjectId(), (IndexableFieldType)TextField.TYPE_NOT_STORED));
        }
    }

    private void setThumbnailField(FullIndexEntry indexEntry, Document doc) {
        if (indexEntry.getThumbnail() != null && indexEntry.getThumbnailMimeType() != null) {
            doc.add((IndexableField)new StringField(THUMBNAIL, indexEntry.getThumbnail(), Field.Store.YES));
            doc.add((IndexableField)new StringField(THUMBNAIL_MIMETYPE, indexEntry.getThumbnailMimeType(), Field.Store.YES));
            doc.add((IndexableField)new StringField(THUMBNAIL_DIRECTORY, indexEntry.getThumbnailDirectory(), Field.Store.YES));
        }
    }

    private void setCreationAndUpdateFields(FullIndexEntry indexEntry, Document doc) {
        doc.add((IndexableField)new StringField(CREATIONDATE, indexEntry.getCreationDate(), Field.Store.YES));
        doc.add((IndexableField)new StringField(CREATIONUSER, indexEntry.getCreationUser(), Field.Store.YES));
        doc.add((IndexableField)new StringField(LASTUPDATEDATE, indexEntry.getLastModificationDate(), Field.Store.YES));
        doc.add((IndexableField)new StringField(LASTUPDATEUSER, indexEntry.getLastModificationUser(), Field.Store.YES));
        doc.add((IndexableField)new StringField(STARTDATE, indexEntry.getStartDate(), Field.Store.YES));
        doc.add((IndexableField)new StringField(ENDDATE, indexEntry.getEndDate(), Field.Store.YES));
    }

    private void setPreviewAndKeyWordsField(FullIndexEntry indexEntry, Document doc) {
        Iterator<String> languages = indexEntry.getLanguages();
        while (languages.hasNext()) {
            String language = languages.next();
            if (indexEntry.getPreview(language) != null) {
                doc.add((IndexableField)new Field(this.getFieldName(PREVIEW, language), (CharSequence)indexEntry.getPreview(language), (IndexableFieldType)TextField.TYPE_STORED));
            }
            if (indexEntry.getKeywords(language) == null) continue;
            doc.add((IndexableField)new Field(this.getFieldName(KEYWORDS, language), (CharSequence)indexEntry.getKeywords(language), (IndexableFieldType)TextField.TYPE_NOT_STORED));
        }
    }

    private void setTitleField(FullIndexEntry indexEntry, Document doc) {
        Iterator<String> languages = indexEntry.getLanguages();
        if (indexEntry.getObjectType() != null && indexEntry.getObjectType().startsWith(ATTACHMENT_PREFIX)) {
            String lang = indexEntry.getLang();
            if (StringUtil.isDefined((String)indexEntry.getTitle(lang))) {
                doc.add((IndexableField)new Field(this.getFieldName(TITLE, lang), (CharSequence)indexEntry.getTitle(lang), (IndexableFieldType)TextField.TYPE_STORED));
            }
            doc.add((IndexableField)new Field(this.getFieldName(FILENAME, lang), (CharSequence)indexEntry.getFilename(), (IndexableFieldType)TextField.TYPE_STORED));
        } else {
            while (languages.hasNext()) {
                String language = languages.next();
                if (indexEntry.getTitle(language) == null) continue;
                doc.add((IndexableField)new Field(this.getFieldName(TITLE, language), (CharSequence)indexEntry.getTitle(language), (IndexableFieldType)TextField.TYPE_STORED));
            }
        }
    }

    private String buildStringForFacets(List<String> fieldsForFacets) {
        String fieldsForFacet = "";
        if (fieldsForFacets != null && !fieldsForFacets.isEmpty()) {
            fieldsForFacet = StringUtils.join(fieldsForFacets, (char)',');
        }
        return fieldsForFacet;
    }

    private String getFieldName(String name, String language) {
        if (!I18NHelper.isI18nContentActivated || I18NHelper.isDefaultLanguage(language)) {
            return name;
        }
        return name + "_" + language;
    }

    private void addFile(Document doc, FileDescription fileDescription) {
        File file = new File(fileDescription.getPath());
        if (!file.exists() || !file.isFile()) {
            return;
        }
        try {
            this.getReader(fileDescription).ifPresent(r -> {
                Field field = new Field(this.getFieldName(CONTENT, fileDescription.getLang()), r, (IndexableFieldType)TextField.TYPE_NOT_STORED);
                doc.add((IndexableField)field);
            });
        }
        catch (RuntimeException e) {
            IndexingLogger.indexingLogger().error("Failed to parse file " + fileDescription.getPath(), (Throwable)e);
        }
    }

    static {
        maxFieldLength = settings.getInteger("lucene.maxFieldLength", maxFieldLength);
        mergeFactor = settings.getInteger("lucene.mergeFactor", mergeFactor);
        maxMergeDocs = settings.getInteger("lucene.maxMergeDocs", maxMergeDocs);
        String stringValue = settings.getString("lucene.RAMBufferSizeMB", Double.toString(16.0));
        DEFAULT_RAM_BUFFER_SIZE_MB = Double.parseDouble(stringValue);
        ENABLE_DYM_INDEXING = settings.getBoolean("enableDymIndexing", false);
        SILVERPEAS_SERVER_NAME = settings.getString("server.name", "Silverpeas");
    }
}

