/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.record;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.FormRuntimeException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.dummy.DummyRecordSet;
import org.silverpeas.core.contribution.content.form.record.FormEncryptionContentIterator;
import org.silverpeas.core.contribution.content.form.record.GenericDataRecord;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSet;
import org.silverpeas.core.contribution.content.form.record.GenericRecordTemplate;
import org.silverpeas.core.contribution.content.form.record.IdentifiedRecordTemplate;
import org.silverpeas.core.contribution.content.form.record.RecordRow;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.security.encryption.ContentEncryptionService;
import org.silverpeas.core.security.encryption.ContentEncryptionServiceProvider;
import org.silverpeas.core.security.encryption.cipher.CryptoException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class GenericRecordSetManager {
    private static final GenericRecordSetManager instance = new GenericRecordSetManager();
    private static final String SEPARATOR = "|";
    private static final String INSERT_INTO = "insert into ";
    private static final String DELETE_FROM = "delete from ";
    private static final String FIELD_VALUE = "fieldValue";
    private final Map<String, GenericRecordSet> cache = new HashMap<String, GenericRecordSet>();
    private static final String TEMPLATE_TABLE = "SB_FormTemplate_Template";
    private static final String TEMPLATE_COLUMNS = "templateId,externalId,templateName";
    private static final String SELECT_TEMPLATE = "select templateId,externalId,templateName from SB_FormTemplate_Template where externalId=?";
    private static final String INSERT_TEMPLATE = "insert into SB_FormTemplate_Template(templateId,externalId,templateName) values (?,?,?)";
    private static final String WHERE_TEMPLATE_ID_EQUAL_GIVEN_VALUE = " where templateId=?";
    private static final String DELETE_TEMPLATE = "delete from SB_FormTemplate_Template where templateId=?";
    private static final String TEMPLATE_FIELDS_TABLE = "SB_FormTemplate_TemplateField";
    private static final String TEMPLATE_FIELDS_COLUMNS = "templateId,fieldName,fieldIndex,fieldType,isMandatory,isReadOnly,isHidden";
    private static final String SELECT_TEMPLATE_FIELDS = "select templateId,fieldName,fieldIndex,fieldType,isMandatory,isReadOnly,isHidden from SB_FormTemplate_TemplateField where templateId=? order by fieldIndex";
    private static final String INSERT_TEMPLATE_FIELD = "insert into SB_FormTemplate_TemplateField(templateId,fieldName,fieldIndex,fieldType,isMandatory,isReadOnly,isHidden) values (?,?,?,?,?,?,?)";
    private static final String DELETE_TEMPLATE_FIELDS = "delete from SB_FormTemplate_TemplateField where templateId=?";
    private static final String RECORD_TABLE = "SB_FormTemplate_Record";
    private static final String RECORD_COLUMNS = "recordId,templateId,externalId,lang";
    private static final String SELECT_RECORD = "SELECT recordId, templateId, externalId, lang FROM sb_formtemplate_record WHERE templateId=? AND externalId=?";
    private static final String INSERT_RECORD = "insert into SB_FormTemplate_Record(recordId,templateId,externalId,lang) values (?,?,?,?)";
    private static final String DELETE_TEMPLATE_RECORDS = "delete from SB_FormTemplate_Record where templateId=?";
    private static final String DELETE_RECORD = "delete from SB_FormTemplate_Record where recordId=?";
    private static final String MOVE_RECORD = "update SB_FormTemplate_Record set templateId = ? where recordId = ? ";
    private static final String FIELDS_TABLE = "SB_FormTemplate_TextField";
    private static final String FIELDS_COLUMNS = "recordId,fieldName,fieldValue,fieldValueIndex";
    private static final String SELECT_FIELDS = "SELECT recordId, fieldName, fieldValue, fieldValueIndex FROM sb_formtemplate_textfield WHERE recordId=? order by fieldName, fieldValueIndex";
    private static final String INSERT_FIELD = "insert into SB_FormTemplate_TextField(recordId,fieldName,fieldValue,fieldValueIndex) values (?,?,?,?)";
    private static final String UPDATE_FIELD = "update SB_FormTemplate_TextField set fieldValue=? where recordId=? and fieldName=? and fieldValueIndex=?";
    private static final String DELETE_TEMPLATE_RECORDS_FIELDS = "delete from SB_FormTemplate_TextField where recordId in (select recordId from SB_FormTemplate_Record where templateId=?)";
    private static final String DELETE_RECORD_FIELDS = "delete from SB_FormTemplate_TextField where recordId=?";
    private static final String TF_ALIAS = " tf, ";
    private static final String REC_ALIAS = " rec, ";
    private static final String SELECT_TEMPLATE_RECORD_VALUES = "select fieldValue from SB_FormTemplate_TextField tf, SB_FormTemplate_Record rec, SB_FormTemplate_Template tpl where tf.fieldName= ? and tf.recordId = rec.recordId and rec.externalId = ? and rec.templateId = tpl.templateId and tpl.externalId = ?";
    private static final String SELECT_TEMPLATE_RECORD_ENTRIES = "SELECT * FROM SB_FormTemplate_TextField tf, SB_FormTemplate_Record rec, SB_FormTemplate_Template tpl WHERE tpl.templatename = ? AND rec.templateId = tpl.templateId AND tf.recordId = rec.recordId";
    private static final String SELECT_TEMPLATE_RECORDS_BY_FIELDVALUE = "SELECT rec.recordId,rec.templateId,rec.externalId,rec.lang FROM SB_FormTemplate_TextField tf, SB_FormTemplate_Record rec, SB_FormTemplate_Template tpl WHERE tpl.templateid = ? AND rec.templateId = tpl.templateId AND tf.recordId = rec.recordId AND tf.fieldName = ?  AND (lower(tf.fieldvalue) like lower(?)  OR lower(tf.fieldvalue) like lower(?)  OR lower(tf.fieldvalue) like lower(?)  OR lower(tf.fieldvalue) like lower(?))";
    private static final String SELECT_NUMBER_OF_RECORDS_BY_TEMPLATE_AND_COMPONENTS = "select t.externalid, count(r.recordid) from SB_FormTemplate_Template t, SB_FormTemplate_Record r where r.templateid = t.templateid and t.templatename = ? GROUP BY t.externalid";
    private static final String SELECT_ALL_EXTERNAL_IDS_OF_RECORDS = "select distinct externalid from SB_FormTemplate_Template";

    private GenericRecordSetManager() {
    }

    public static GenericRecordSetManager getInstance() {
        return instance;
    }

    public List<String> getExternalIdOfComponentInstanceId(String componentInstanceId) throws FormException {
        try {
            return JdbcSqlQuery.select((String)"externalId from SB_FormTemplate_Template").where("externalId like ?", new Object[]{componentInstanceId + ":%"}).execute(row -> row.getString(1));
        }
        catch (SQLException e) {
            throw new FormException(e);
        }
    }

    public GenericRecordSet createRecordSet(String externalId, RecordTemplate template) throws FormException {
        return this.createRecordSet(externalId, template, null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GenericRecordSet createRecordSet(String externalId, RecordTemplate template, String templateName, boolean encrypted) throws FormException {
        IdentifiedRecordTemplate identifiedTemplate = new IdentifiedRecordTemplate(template);
        identifiedTemplate.setExternalId(externalId);
        identifiedTemplate.setTemplateName(templateName);
        identifiedTemplate.setEncrypted(encrypted);
        try (Connection con = this.getConnection();){
            IdentifiedRecordTemplate existingOne = this.selectTemplateRow(con, externalId);
            if (existingOne == null) {
                this.insertTemplateRow(con, identifiedTemplate);
                if (templateName == null) {
                    this.insertTemplateFieldRows(con, identifiedTemplate);
                }
                GenericRecordSet newSet = new GenericRecordSet(identifiedTemplate);
                this.cacheRecordSet(externalId, newSet);
                GenericRecordSet genericRecordSet2 = newSet;
                return genericRecordSet2;
            }
            GenericRecordSet genericRecordSet = (GenericRecordSet)this.getRecordSet(externalId);
            return genericRecordSet;
        }
        catch (SQLException e) {
            throw new FormException(e);
        }
    }

    public String getRawValue(String templateExternalId, String recordExternalId, String fieldName) throws FormException {
        String string;
        block8: {
            Connection con = this.getConnection();
            try {
                string = this.selectRecordFieldsRow(con, templateExternalId, recordExternalId, fieldName);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new FormException("Cannot get raw value for templateExternalId '" + templateExternalId + "' and recordExternalId '" + recordExternalId + "'", e);
                }
            }
            con.close();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecordSet getRecordSet(String externalId) throws FormException {
        GenericRecordSet cachedSet = this.getCachedRecordSet(externalId);
        if (cachedSet != null) {
            return cachedSet;
        }
        try (Connection con = this.getConnection();){
            IdentifiedRecordTemplate template = this.selectTemplateRow(con, externalId);
            if (template == null) {
                DummyRecordSet dummyRecordSet = new DummyRecordSet();
                return dummyRecordSet;
            }
            String templateName = template.getTemplateName();
            if (templateName != null && !templateName.isEmpty()) {
                this.selectTemplateFieldsFromXML(template);
            } else {
                this.selectTemplateFieldRows(con, template);
            }
            cachedSet = new GenericRecordSet(template);
            this.cacheRecordSet(externalId, cachedSet);
            GenericRecordSet genericRecordSet = cachedSet;
            return genericRecordSet;
        }
        catch (SQLException e) {
            throw new FormException(e);
        }
    }

    public void removeRecordSet(String externalId) throws FormException {
        this.removeCachedRecordSet(externalId);
        try (Connection con = this.getConnection();){
            IdentifiedRecordTemplate template = this.selectTemplateRow(con, externalId);
            if (template == null) {
                SilverLogger.getLogger((Object)this).error("Unknown template: externalId = " + externalId, new Object[0]);
            } else {
                this.deleteFieldRows(con, template);
                this.deleteRecordRows(con, template);
                this.deleteTemplateFieldRows(con, template);
                this.deleteTemplateRow(con, template);
            }
        }
        catch (SQLException e) {
            throw new FormException(e);
        }
    }

    private GenericRecordSet getCachedRecordSet(String externalId) {
        return this.cache.get(externalId);
    }

    private void cacheRecordSet(String externalId, GenericRecordSet set) {
        this.cache.put(externalId, set);
    }

    private void removeCachedRecordSet(String externalId) {
        this.cache.remove(externalId);
    }

    public void removeTemplateFromCache(String templateName) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Map.Entry<String, GenericRecordSet> recordSets : this.cache.entrySet()) {
            GenericRecordSet rs = recordSets.getValue();
            IdentifiedRecordTemplate template = (IdentifiedRecordTemplate)rs.getRecordTemplate();
            if (template == null || !templateName.equalsIgnoreCase(template.getTemplateName())) continue;
            ids.add(recordSets.getKey());
        }
        ids.forEach(this::removeCachedRecordSet);
    }

    public DataRecord getRecord(IdentifiedRecordTemplate template, String objectId) throws FormException {
        return this.getRecord(template, objectId, null);
    }

    public DataRecord getRecord(IdentifiedRecordTemplate template, String objectId, String language) throws FormException {
        GenericDataRecord genericDataRecord;
        block13: {
            Connection con = this.getConnection();
            try {
                GenericDataRecord record = this.selectRecordRow(con, template, objectId, language);
                if (record != null) {
                    record.setLanguage(language);
                } else if (I18NHelper.isI18nContentEnabled()) {
                    ArrayList<String> languages = new ArrayList<String>(I18NHelper.getAllSupportedLanguages());
                    languages.remove(language);
                    for (String lang : languages) {
                        record = this.selectRecordRow(con, template, objectId, lang);
                        if (record == null) continue;
                        record.setLanguage(lang);
                        break;
                    }
                }
                if (record != null) {
                    this.selectFieldRows(con, template, record);
                }
                genericDataRecord = record;
                if (con == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new FormException(e);
                }
            }
            con.close();
        }
        return genericDataRecord;
    }

    public List<String> getLanguagesOfRecord(IdentifiedRecordTemplate template, String externalId) throws FormException {
        List<String> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = this.selectLanguagesOfRecord(con, template, externalId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new FormException(e);
                }
            }
            con.close();
        }
        return list;
    }

    public void insertRecord(IdentifiedRecordTemplate template, DataRecord insertedRecord) throws FormException {
        try (Connection con = this.getConnection();){
            GenericDataRecord record = (GenericDataRecord)insertedRecord;
            this.insertRecordRow(con, template, record);
            this.insertFieldRows(con, template, record);
        }
        catch (ClassCastException | SQLException e) {
            throw new FormException(e);
        }
    }

    public void moveRecord(int recordId, IdentifiedRecordTemplate templateTo) throws FormException {
        try (Connection con = this.getConnection();){
            this.updateTemplateId(con, templateTo.getInternalId(), recordId);
        }
        catch (SQLException e) {
            throw new FormException(e);
        }
    }

    public void updateRecord(IdentifiedRecordTemplate template, DataRecord updatedRecord) throws FormException {
        try (Connection con = this.getConnection();){
            GenericDataRecord record = (GenericDataRecord)updatedRecord;
            this.updateFieldRows(con, template, record);
        }
        catch (ClassCastException | SQLException e) {
            throw new FormException(e);
        }
    }

    public void deleteRecord(DataRecord deletedRecord) throws FormException {
        try (Connection con = this.getConnection();){
            GenericDataRecord record = (GenericDataRecord)deletedRecord;
            this.deleteFieldRows(con, record);
            this.deleteRecordRows(con, record);
        }
        catch (ClassCastException | SQLException e) {
            throw new FormException(e);
        }
    }

    public void encryptData(String templateName) throws CryptoException {
        this.encryptOrDecryptData(templateName, true);
    }

    public void decryptData(String templateName) throws CryptoException {
        this.encryptOrDecryptData(templateName, false);
    }

    public List<DataRecord> getRecords(IdentifiedRecordTemplate template, String fieldName, String fieldValue) throws FormException {
        List<DataRecord> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = this.selectRecords(con, template, fieldName, fieldValue);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new FormException(e);
                }
            }
            con.close();
        }
        return list;
    }

    public Map<String, Integer> getNumberOfRecordsByTemplateAndComponents(String templateName) throws FormException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (Connection con = this.getConnection();
             PreparedStatement select = con.prepareStatement(SELECT_NUMBER_OF_RECORDS_BY_TEMPLATE_AND_COMPONENTS);){
            select.setString(1, templateName);
            try (ResultSet rs = select.executeQuery();){
                while (rs.next()) {
                    int count = rs.getInt(2);
                    result.put(this.extractComponentId(rs), count);
                }
            }
        }
        catch (SQLException e) {
            throw new FormException(e);
        }
        return result;
    }

    public Set<String> getAllComponentIdsOfRecords() throws FormException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (Connection con = this.getConnection();
             PreparedStatement select = con.prepareStatement(SELECT_ALL_EXTERNAL_IDS_OF_RECORDS);
             ResultSet rs = select.executeQuery();){
            while (rs.next()) {
                result.add(this.extractComponentId(rs));
            }
        }
        catch (SQLException e) {
            throw new FormException(e);
        }
        return result;
    }

    private String extractComponentId(ResultSet rs) throws SQLException {
        String externalId = rs.getString(1);
        return externalId.split(":")[0];
    }

    private List<DataRecord> selectRecords(Connection con, IdentifiedRecordTemplate template, String fieldName, String fieldValue) throws SQLException, FormException {
        ArrayList<DataRecord> records = new ArrayList<DataRecord>();
        try (PreparedStatement select = con.prepareStatement(SELECT_TEMPLATE_RECORDS_BY_FIELDVALUE);){
            select.setInt(1, template.getInternalId());
            select.setString(2, fieldName);
            select.setString(3, fieldValue);
            select.setString(4, "%##" + fieldValue);
            select.setString(5, "%##" + fieldValue + "##%");
            select.setString(6, fieldValue + "##%");
            try (ResultSet rs = select.executeQuery();){
                while (rs.next()) {
                    int internalId = rs.getInt(1);
                    String objectId = rs.getString(3);
                    GenericDataRecord record = new GenericDataRecord(template);
                    record.setInternalId(internalId);
                    record.setId(objectId);
                    records.add(record);
                }
            }
        }
        return records;
    }

    private void encryptOrDecryptData(String templateName, boolean encrypt) throws CryptoException {
        ContentEncryptionService encryptionService = this.getEncryptionService();
        FormEncryptionContentIterator contentIterator = new FormEncryptionContentIterator(templateName);
        if (encrypt) {
            try {
                encryptionService.encryptContents(contentIterator);
            }
            catch (FormRuntimeException e) {
                throw new CryptoException("The encryption failed!", (Throwable)((Object)e));
            }
        }
        try {
            encryptionService.decryptContents(contentIterator);
        }
        catch (Exception e) {
            throw new CryptoException("The decryption failed!", e);
        }
    }

    private ContentEncryptionService getEncryptionService() {
        return ContentEncryptionServiceProvider.getContentEncryptionService();
    }

    protected void updateFieldRows(Connection con, List<RecordRow> rows) throws SQLException {
        try (PreparedStatement update = con.prepareStatement(UPDATE_FIELD);){
            for (RecordRow row : rows) {
                update.setString(1, row.getFieldValue());
                update.setInt(2, row.getRecordId());
                update.setString(3, row.getFieldName());
                int nbRowsUpdated = update.executeUpdate();
                if (nbRowsUpdated == 1) continue;
                SilverLogger.getLogger((Object)this).error("Update failed for record " + row.getRecordId() + " and field '" + row.getFieldName() + "' with value " + row.getFieldValue(), new Object[0]);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected List<RecordRow> getAllRecordsOfTemplate(String templateName) throws FormException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String selectRecordFieldsRow(Connection con, String templateExternalId, String recordExternalId, String fieldName) throws SQLException {
        try (PreparedStatement select = con.prepareStatement(SELECT_TEMPLATE_RECORD_VALUES);){
            String string;
            block16: {
                ResultSet rs;
                block14: {
                    String string2;
                    block15: {
                        select.setString(1, fieldName);
                        select.setString(2, recordExternalId);
                        select.setString(3, templateExternalId);
                        rs = select.executeQuery();
                        try {
                            if (rs.next()) break block14;
                            string2 = null;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = rs.getString(FIELD_VALUE);
                if (rs == null) break block16;
                rs.close();
            }
            return string;
        }
    }

    private void selectTemplateFieldsFromXML(IdentifiedRecordTemplate template) throws FormException {
        FieldTemplate[] fields;
        GenericRecordTemplate genericRecordTemplate;
        try {
            PublicationTemplate publicationTemplateImpl = PublicationTemplateManager.getInstance().loadPublicationTemplate(template.getTemplateName());
            genericRecordTemplate = (GenericRecordTemplate)publicationTemplateImpl.getRecordTemplate();
            template.setEncrypted(publicationTemplateImpl.isDataEncrypted());
        }
        catch (PublicationTemplateException e) {
            throw new FormException((Throwable)((Object)e));
        }
        GenericRecordTemplate wrapped = (GenericRecordTemplate)template.getWrappedTemplate();
        for (FieldTemplate field : fields = genericRecordTemplate.getFieldTemplates()) {
            GenericFieldTemplate fieldTemplate = GenericRecordSetManager.createGenericFieldTemplate(field);
            wrapped.addFieldTemplate(fieldTemplate);
        }
    }

    private static GenericFieldTemplate createGenericFieldTemplate(FieldTemplate field) throws FormException {
        String displayName = field.getDisplayerName();
        GenericFieldTemplate fieldTemplate = new GenericFieldTemplate(field.getFieldName(), field.getTypeName());
        fieldTemplate.setMandatory(field.isMandatory());
        fieldTemplate.setReadOnly(field.isReadOnly());
        fieldTemplate.setHidden(field.isHidden());
        fieldTemplate.setDisabled(field.isDisabled());
        fieldTemplate.setSearchable(field.isSearchable());
        fieldTemplate.setDisplayerName(displayName != null ? displayName : "");
        fieldTemplate.setLabel(field.getLabel());
        fieldTemplate.setUsedAsFacet(field.isUsedAsFacet());
        fieldTemplate.setParametersObj(field.getParameters());
        fieldTemplate.setMaximumNumberOfOccurrences(field.getMaximumNumberOfOccurrences());
        return fieldTemplate;
    }

    private Connection getConnection() throws FormException {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new FormException(e);
        }
    }

    private int getNextId(String tableName, String idColumn) {
        int nextId = DBUtil.getNextId((String)tableName, (String)idColumn);
        if (nextId == 0) {
            return 1;
        }
        return nextId;
    }

    private void insertTemplateRow(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        int internalId = this.getNextId(TEMPLATE_TABLE, "templateId");
        template.setInternalId(internalId);
        String externalId = template.getExternalId();
        String templateName = template.getTemplateName();
        try (PreparedStatement insert = con.prepareStatement(INSERT_TEMPLATE);){
            insert.setInt(1, internalId);
            insert.setString(2, externalId);
            insert.setString(3, templateName);
            insert.execute();
        }
    }

    private void insertTemplateFieldRows(Connection con, IdentifiedRecordTemplate template) throws SQLException, FormException {
        try (PreparedStatement insert = con.prepareStatement(INSERT_TEMPLATE_FIELD);){
            int internalId = template.getInternalId();
            FieldTemplate[] fields = template.getFieldTemplates();
            for (int i = 0; i < fields.length; ++i) {
                insert.setInt(1, internalId);
                insert.setString(2, fields[i].getFieldName());
                insert.setInt(3, i);
                insert.setString(4, fields[i].getTypeName());
                if (fields[i].isMandatory()) {
                    insert.setInt(5, 1);
                } else {
                    insert.setInt(5, 0);
                }
                if (fields[i].isReadOnly()) {
                    insert.setInt(6, 1);
                } else {
                    insert.setInt(6, 0);
                }
                insert.setInt(7, 1);
                insert.execute();
            }
        }
    }

    private IdentifiedRecordTemplate selectTemplateRow(Connection con, String externalId) throws SQLException {
        try (PreparedStatement select = con.prepareStatement(SELECT_TEMPLATE);){
            IdentifiedRecordTemplate identifiedRecordTemplate;
            block16: {
                ResultSet rs;
                block14: {
                    IdentifiedRecordTemplate identifiedRecordTemplate2;
                    block15: {
                        select.setString(1, externalId);
                        rs = select.executeQuery();
                        try {
                            if (rs.next()) break block14;
                            identifiedRecordTemplate2 = null;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return identifiedRecordTemplate2;
                }
                int internalId = rs.getInt(1);
                String templateName = rs.getString(3);
                IdentifiedRecordTemplate template = new IdentifiedRecordTemplate(new GenericRecordTemplate());
                template.setInternalId(internalId);
                template.setExternalId(externalId);
                template.setTemplateName(templateName);
                identifiedRecordTemplate = template;
                if (rs == null) break block16;
                rs.close();
            }
            return identifiedRecordTemplate;
        }
    }

    private void selectTemplateFieldRows(Connection con, IdentifiedRecordTemplate template) throws SQLException, FormException {
        GenericRecordTemplate wrapped = (GenericRecordTemplate)template.getWrappedTemplate();
        try (PreparedStatement select = con.prepareStatement(SELECT_TEMPLATE_FIELDS);){
            select.setInt(1, template.getInternalId());
            try (ResultSet rs = select.executeQuery();){
                while (rs.next()) {
                    String fieldName = rs.getString(2);
                    String fieldType = rs.getString(4);
                    boolean isMandatory = rs.getBoolean(5);
                    boolean isReadOnly = rs.getBoolean(6);
                    boolean isHidden = rs.getBoolean(7);
                    GenericFieldTemplate fieldTemplate = new GenericFieldTemplate(fieldName, fieldType);
                    fieldTemplate.setMandatory(isMandatory);
                    fieldTemplate.setReadOnly(isReadOnly);
                    fieldTemplate.setHidden(isHidden);
                    wrapped.addFieldTemplate(fieldTemplate);
                }
            }
        }
    }

    private void deleteFieldRows(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        try (PreparedStatement delete = con.prepareStatement(DELETE_TEMPLATE_RECORDS_FIELDS);){
            int internalId = template.getInternalId();
            delete.setInt(1, internalId);
            delete.execute();
        }
    }

    private void deleteRecordRows(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        try (PreparedStatement delete = con.prepareStatement(DELETE_TEMPLATE_RECORDS);){
            int internalId = template.getInternalId();
            delete.setInt(1, internalId);
            delete.execute();
        }
    }

    private void deleteTemplateFieldRows(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        try (PreparedStatement delete = con.prepareStatement(DELETE_TEMPLATE_FIELDS);){
            int internalId = template.getInternalId();
            delete.setInt(1, internalId);
            delete.execute();
        }
    }

    private void deleteTemplateRow(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        try (PreparedStatement delete = con.prepareStatement(DELETE_TEMPLATE);){
            int internalId = template.getInternalId();
            delete.setInt(1, internalId);
            delete.execute();
        }
    }

    private void insertRecordRow(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException {
        try (PreparedStatement insert = con.prepareStatement(INSERT_RECORD);){
            int internalId = this.getNextId(RECORD_TABLE, "recordId");
            record.setInternalId(internalId);
            int templateId = template.getInternalId();
            String externalId = record.getId();
            insert.setInt(1, internalId);
            insert.setInt(2, templateId);
            insert.setString(3, externalId);
            if (!I18NHelper.isI18nContentActivated || I18NHelper.isDefaultLanguage(record.getLanguage())) {
                insert.setNull(4, 12);
            } else {
                insert.setString(4, record.getLanguage());
            }
            insert.execute();
        }
    }

    private void insertFieldRows(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException, FormException {
        int recordId = record.getInternalId();
        try {
            Map<String, String> rows = this.getRowsToStore(record, template.isEncrypted());
            for (Map.Entry<String, String> fieldNameIndexed : rows.entrySet()) {
                String[] fieldNameAndIndex = StringUtil.split((String)fieldNameIndexed.getKey(), (String)SEPARATOR);
                String fieldName = fieldNameAndIndex[0];
                int fieldValueIndex = Integer.parseInt(fieldNameAndIndex[1]);
                String fieldValue = fieldNameIndexed.getValue();
                this.executeInsertQuery(con, recordId, fieldValueIndex, fieldName, fieldValue);
            }
        }
        catch (CryptoException e) {
            throw new FormException(e);
        }
    }

    private void executeInsertQuery(Connection con, int recordId, int fieldValueIndex, String fieldName, String fieldValue) throws SQLException {
        try (PreparedStatement insert = con.prepareStatement(INSERT_FIELD);){
            insert.setInt(1, recordId);
            insert.setString(2, fieldName);
            insert.setString(3, fieldValue);
            insert.setInt(4, fieldValueIndex);
            insert.execute();
        }
    }

    private GenericDataRecord selectRecordRow(Connection con, IdentifiedRecordTemplate template, String externalId, String language) throws SQLException, FormException {
        if (!I18NHelper.isI18nContentActivated || I18NHelper.isDefaultLanguage(language)) {
            language = null;
        }
        if (language != null) {
            return this.selectDataRecordByExternalIdAndByLanguage(con, template, externalId, language);
        }
        return this.selectDataRecordByExternalId(con, template, externalId);
    }

    private GenericDataRecord selectDataRecordByExternalId(Connection con, IdentifiedRecordTemplate template, String externalId) throws SQLException, FormException {
        try (PreparedStatement select = con.prepareStatement("SELECT recordId, templateId, externalId, lang FROM sb_formtemplate_record WHERE templateId=? AND externalId=? AND lang is null");){
            GenericDataRecord genericDataRecord;
            block12: {
                select.setInt(1, template.getInternalId());
                select.setString(2, externalId);
                ResultSet rs = select.executeQuery();
                try {
                    genericDataRecord = this.fetchGenericDataRecord(rs, template, externalId);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return genericDataRecord;
        }
    }

    private GenericDataRecord selectDataRecordByExternalIdAndByLanguage(Connection con, IdentifiedRecordTemplate template, String externalId, String language) throws SQLException, FormException {
        try (PreparedStatement select = con.prepareStatement("SELECT recordId, templateId, externalId, lang FROM sb_formtemplate_record WHERE templateId=? AND externalId=? AND lang = ? ");){
            GenericDataRecord genericDataRecord;
            block13: {
                select.setInt(1, template.getInternalId());
                select.setString(2, externalId);
                select.setString(3, language);
                ResultSet rs = select.executeQuery();
                try {
                    GenericDataRecord record = this.fetchGenericDataRecord(rs, template, externalId);
                    if (record != null) {
                        record.setLanguage(language);
                    }
                    genericDataRecord = record;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return genericDataRecord;
        }
    }

    private GenericDataRecord fetchGenericDataRecord(ResultSet rs, IdentifiedRecordTemplate template, String externalId) throws SQLException, FormException {
        if (!rs.next()) {
            return null;
        }
        int internalId = rs.getInt(1);
        GenericDataRecord record = new GenericDataRecord(template);
        record.setInternalId(internalId);
        record.setId(externalId);
        return record;
    }

    private void selectFieldRows(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException, FormException {
        try (PreparedStatement select = con.prepareStatement(SELECT_FIELDS);){
            select.setInt(1, record.getInternalId());
            try (ResultSet rs = select.executeQuery();){
                Map<String, String> rows = new TreeMap<String, String>();
                while (rs.next()) {
                    String fieldName = rs.getString("fieldName");
                    String fieldValue = rs.getString(FIELD_VALUE);
                    int fieldValueIndex = rs.getInt("fieldvalueindex");
                    rows.put(fieldName + SEPARATOR + fieldValueIndex, fieldValue);
                }
                if (template.isEncrypted()) {
                    rows = this.getEncryptionService().decryptContent(rows);
                }
                for (Map.Entry fieldNameIndexed : rows.entrySet()) {
                    String[] fieldNameAndIndex = StringUtil.split((String)((String)fieldNameIndexed.getKey()), (String)SEPARATOR);
                    String fieldName = fieldNameAndIndex[0];
                    int fieldValueIndex = Integer.parseInt(fieldNameAndIndex[1]);
                    Field field = record.getField(fieldName, fieldValueIndex);
                    String fieldValue = (String)fieldNameIndexed.getValue();
                    if (field == null) continue;
                    field.setStringValue(fieldValue);
                }
            }
        }
        catch (CryptoException e) {
            throw new FormException(e);
        }
    }

    private List<String> selectLanguagesOfRecord(Connection con, IdentifiedRecordTemplate template, String externalId) throws SQLException {
        ArrayList<String> languages = new ArrayList<String>();
        try (PreparedStatement select = con.prepareStatement(SELECT_RECORD);){
            select.setInt(1, template.getInternalId());
            select.setString(2, externalId);
            try (ResultSet rs = select.executeQuery();){
                while (rs.next()) {
                    String language = rs.getString("lang");
                    if (!StringUtil.isDefined((String)language)) {
                        language = I18NHelper.DEFAULT_LANGUAGE;
                    }
                    languages.add(language);
                }
            }
            ArrayList<String> arrayList = languages;
            return arrayList;
        }
    }

    private void updateFieldRows(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException, FormException {
        try (PreparedStatement update = con.prepareStatement(UPDATE_FIELD);){
            int recordId = record.getInternalId();
            Map<String, String> rows = this.getRowsToStore(record, template.isEncrypted());
            for (Map.Entry<String, String> fieldNameIndexed : rows.entrySet()) {
                String[] fieldNameAndIndex = StringUtil.split((String)fieldNameIndexed.getKey(), (String)SEPARATOR);
                String fieldName = fieldNameAndIndex[0];
                int fieldValueIndex = Integer.parseInt(fieldNameAndIndex[1]);
                String fieldValue = fieldNameIndexed.getValue();
                update.setString(1, fieldValue);
                update.setInt(2, recordId);
                update.setString(3, fieldName);
                update.setInt(4, fieldValueIndex);
                int nbRowsCount = update.executeUpdate();
                if (nbRowsCount != 0) continue;
                this.executeInsertQuery(con, recordId, fieldValueIndex, fieldName, fieldValue);
            }
        }
        catch (CryptoException e) {
            throw new FormException(e);
        }
    }

    private Map<String, String> getRowsToStore(GenericDataRecord record, boolean crypt) throws CryptoException {
        Map<String, String> rows = new HashMap<String, String>();
        for (Field field : record.getFields()) {
            String fieldNameIndexed = field.getName() + SEPARATOR + field.getOccurrence();
            rows.put(fieldNameIndexed, field.getStringValue());
        }
        if (crypt) {
            rows = this.getEncryptionService().encryptContent(rows);
        }
        return rows;
    }

    private void deleteFieldRows(Connection con, GenericDataRecord record) throws SQLException {
        try (PreparedStatement delete = con.prepareStatement(DELETE_RECORD_FIELDS);){
            int internalId = record.getInternalId();
            delete.setInt(1, internalId);
            delete.execute();
        }
    }

    private void deleteRecordRows(Connection con, GenericDataRecord record) throws SQLException {
        try (PreparedStatement delete = con.prepareStatement(DELETE_RECORD);){
            int internalId = record.getInternalId();
            delete.setInt(1, internalId);
            delete.execute();
        }
    }

    private void updateTemplateId(Connection con, int newTemplateId, int recordId) throws SQLException {
        try (PreparedStatement update = con.prepareStatement(MOVE_RECORD);){
            update.setInt(1, newTemplateId);
            update.setInt(2, recordId);
            update.execute();
        }
    }
}

