/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.contribution.content.form.AbstractField;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;

public class GroupField
extends AbstractField {
    private static final long serialVersionUID = 3278935449715773819L;
    public static final String TYPE = "group";
    private String groupId;

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getValue() {
        if (this.getGroupId() == null) {
            return null;
        }
        if (this.getGroupId().isEmpty()) {
            return "";
        }
        Object group = OrganizationControllerProvider.getOrganisationController().getGroup(this.getGroupId());
        if (group == null) {
            return "group(" + this.getGroupId() + ")";
        }
        return group.getName();
    }

    @Override
    public String getValue(String language) {
        return this.getValue();
    }

    @Override
    public void setValue(String value) throws FormException {
    }

    @Override
    public void setValue(String value, String language) throws FormException {
    }

    @Override
    public boolean acceptValue(String value) {
        return false;
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return false;
    }

    @Override
    public Object getObjectValue() {
        if (this.getGroupId() == null) {
            return null;
        }
        return OrganizationControllerProvider.getOrganisationController().getGroup(this.getGroupId());
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof Group) {
            this.setGroupId(((Group)value).getId());
        } else if (value == null) {
            this.setGroupId("");
        } else {
            throw new FormException("The value " + value + " isn't a user group!", new String[0]);
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        return value instanceof Group && !this.isReadOnly();
    }

    @Override
    public String getStringValue() {
        return this.getGroupId();
    }

    @Override
    public void setStringValue(String value) {
        this.setGroupId(value);
    }

    @Override
    public boolean acceptStringValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return this.getGroupId() == null;
    }

    @Override
    public void setNull() throws FormException {
        this.setGroupId(null);
    }

    public boolean equals(Object o) {
        String s = this.getGroupId();
        if (o instanceof GroupField) {
            String t = ((GroupField)o).getGroupId();
            return s == null || s.equals(t);
        }
        return false;
    }

    @Override
    public int compareTo(Field o) {
        String s = this.getValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof GroupField) {
            String t = o.getValue();
            if (t == null) {
                t = "";
            }
            if (s.equals(t)) {
                s = this.getGroupId();
                if (s == null) {
                    s = "";
                }
                if ((t = ((GroupField)o).getGroupId()) == null) {
                    t = "";
                }
            }
            return s.compareTo(t);
        }
        return -1;
    }

    public int hashCode() {
        String s = this.getGroupId();
        return s.hashCode();
    }
}

