/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.Printable;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.owasp.encoder.Encode;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractTextFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    private static final String[] MANAGED_TYPES = new String[]{"text"};
    private static final String ERROR_MSG_WITH_HYPHEN = "     errorMsg+=\"  - '";
    private static final String JS_NB_ERROR_INCREMENT = "     errorNb++;\n";
    private static final String JS_CARRIAGE_RETURN = "\\n\";\n";
    private static final String JS_CLOSING_BRACE = "   }\n";

    public String[] getManagedTypes() {
        return MANAGED_TYPES;
    }

    protected void addSpecificScript(PrintWriter out, FieldTemplate template, PagesContext pageContext) {
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        String language = pagesContext.getLanguage();
        String label = WebEncodeHelper.javaStringToJsString((String)template.getLabel(language));
        StringBuilder script2 = new StringBuilder(10000);
        AbstractTextFieldDisplayer.produceMandatoryCheck(out, template, pagesContext);
        this.addSpecificScript(out, template, pagesContext);
        Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
        String contentType = parameters.get("contentType");
        if (contentType != null) {
            if (contentType.equals("int")) {
                script2.append("   if (field.value != \"\" && !(/^-?\\d+$/.test(field.value))) {\n");
                script2.append(ERROR_MSG_WITH_HYPHEN).append(label).append("' ").append(Util.getString("GML.MustContainsNumber", language)).append(JS_CARRIAGE_RETURN);
                script2.append(JS_NB_ERROR_INCREMENT);
                script2.append(JS_CLOSING_BRACE);
            } else if (contentType.equals("float")) {
                script2.append("   field.value = field.value.replace(\",\", \".\")\n");
                script2.append("   if (field.value != \"\" && !(/^([+-]?(((\\d+(\\.)?)|(\\d*\\.\\d+))");
                script2.append("([eE][+-]?\\d+)?))$/.test(field.value))) {\n");
                script2.append(ERROR_MSG_WITH_HYPHEN).append(label).append("' ");
                script2.append(Util.getString("GML.MustContainsFloat", language)).append(JS_CARRIAGE_RETURN);
                script2.append(JS_NB_ERROR_INCREMENT);
                script2.append(JS_CLOSING_BRACE);
            }
        }
        String nbMaxCar = parameters.containsKey("maxLength") ? parameters.get("maxLength") : Util.getSetting("nbMaxCar");
        script2.append("   if (! isValidText(field, ").append(nbMaxCar).append(")) {\n");
        script2.append(ERROR_MSG_WITH_HYPHEN).append(label).append("' ").append(Util.getString("ContainsTooLargeText", language)).append(nbMaxCar).append(" ").append(Util.getString("Characters", language)).append(JS_CARRIAGE_RETURN);
        script2.append(JS_NB_ERROR_INCREMENT);
        script2.append(JS_CLOSING_BRACE);
        out.print(script2);
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("Incorrect field type '{0}', expected; {0}", field.getTypeName(), "text");
        }
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("Incorrect field value type. Expected {0}", "text");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return new ArrayList<String>();
    }

    protected Printable setImage(input textInput, @Nullable img image) {
        if (image != null) {
            ElementContainer container = new ElementContainer();
            container.addElement((Element)textInput);
            container.addElement("&nbsp;");
            container.addElement((Element)image);
            return container;
        }
        return textInput;
    }

    protected static input makeTextInput(FieldProperties fieldProps, String cssClass) {
        FieldTemplate template = fieldProps.getTemplate();
        String fieldName = fieldProps.getFieldName();
        Map<String, String> parameters = fieldProps.getParameters();
        input textInput = new input();
        textInput.setName(fieldName);
        textInput.setID(fieldName);
        textInput.setValue(fieldProps.getValue());
        textInput.setType(template.isHidden() ? "hidden" : "text");
        textInput.setMaxlength(parameters.getOrDefault("maxLength", "1000"));
        textInput.setSize(parameters.getOrDefault("size", "50"));
        if (parameters.containsKey("border")) {
            textInput.setBorder(Integer.parseInt(parameters.get("border")));
        }
        if (template.isDisabled()) {
            textInput.setDisabled(true);
        } else if (template.isReadOnly()) {
            textInput.setReadOnly(true);
        }
        if (StringUtil.isDefined((String)cssClass)) {
            textInput.setClass(cssClass);
        }
        return textInput;
    }

    protected FieldProperties getFieldProperties(FieldTemplate template, TextField field, PagesContext pagesContext) {
        String value;
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        Map<String, String> parameters = template.getParameters(pagesContext.getLanguage());
        String defaultValue = this.getDefaultValue(template, pagesContext);
        String string = value = !field.isNull() ? field.getValue(pagesContext.getLanguage()) : defaultValue;
        if (pagesContext.isBlankFieldsUse()) {
            value = "";
        }
        return new FieldProperties().setTemplate(template).setFieldName(fieldName).setParameters(parameters).setValue(value);
    }

    protected static class FieldProperties {
        private FieldTemplate template;
        private String fieldName;
        private String value;
        private Map<String, String> parameters;

        protected FieldProperties() {
        }

        public FieldTemplate getTemplate() {
            return this.template;
        }

        private FieldProperties setTemplate(FieldTemplate template) {
            this.template = template;
            return this;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        private FieldProperties setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public String getValue() {
            return Encode.forHtml((String)this.value);
        }

        private FieldProperties setValue(String value) {
            this.value = value;
            return this;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        private FieldProperties setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }
    }
}

