/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.process;

import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.process.SimpleDocumentSimulationElement;
import org.silverpeas.core.process.annotation.SimulationElementLister;
import org.silverpeas.kernel.exception.NotSupportedException;

public class AttachmentSimulationElementLister
extends SimulationElementLister {
    public AttachmentSimulationElementLister() {
    }

    public AttachmentSimulationElementLister(SimulationElementLister parentElementLister) {
        super(parentElementLister);
    }

    @Override
    public void listElements(ResourceReference sourcePK, String language) {
        for (SimpleDocument document : AttachmentServiceProvider.getAttachmentService().listAllDocumentsByForeignKey(sourcePK, language)) {
            this.addElement(new SimpleDocumentSimulationElement(document));
        }
    }

    @Override
    public void listElements(Object source, String language, ResourceReference targetPK) {
        SimpleDocument document;
        if (source instanceof SimpleDocument) {
            document = (SimpleDocument)source;
            if (this.getActionType().isMove() && document.getInstanceId().equals(targetPK.getInstanceId())) {
                return;
            }
            if (this.getActionType().isUpdate()) {
                SimpleDocument oldDocument = AttachmentServiceProvider.getAttachmentService().searchDocumentById(document.getPk(), language);
                this.addElement(new SimpleDocumentSimulationElement(oldDocument).setOld());
            }
        } else {
            throw new NotSupportedException("This class expects a SimpleDocument as source");
        }
        this.addElement(new SimpleDocumentSimulationElement(document));
    }
}

