/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.upload.FileUploadManager;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.core.util.CollectionUtil;

public class Attachments {
    private Collection<UploadedFile> uploadedFiles;

    private Attachments() {
    }

    public static Attachments from(Collection<UploadedFile> uploadedFiles) {
        Attachments attachments = new Attachments();
        attachments.uploadedFiles = uploadedFiles;
        return attachments;
    }

    public static Attachments from(Map<String, String[]> fileParameters) {
        Attachments attachments = new Attachments();
        User user = User.getCurrentRequester();
        if (user != null) {
            attachments.uploadedFiles = FileUploadManager.getUploadedFiles(fileParameters, user);
        }
        return attachments;
    }

    public boolean isEmpty() {
        return this.uploadedFiles == null || this.uploadedFiles.isEmpty();
    }

    public void attachTo(Contribution contribution) {
        this.attachTo(contribution, I18NHelper.DEFAULT_LANGUAGE);
    }

    public void attachTo(LocalizedContribution contribution) {
        this.attachTo((Contribution)contribution, contribution.getLanguage());
    }

    private void attachTo(Contribution contribution, String language) {
        if (CollectionUtil.isNotEmpty(this.uploadedFiles)) {
            ArrayList<UploadedFile> files = new ArrayList<UploadedFile>(this.uploadedFiles);
            ContributionIdentifier contributionId = contribution.getIdentifier();
            if (AttachmentSettings.listFromYoungestToOldestAdd()) {
                Collections.reverse(files);
            }
            for (UploadedFile uploadedFile : files) {
                uploadedFile.registerAttachment(contributionId, language, contribution.isIndexable());
            }
        }
    }
}

