/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.ical4j;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Uid;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.CalendarEventOccurrenceBuilder;
import org.silverpeas.core.calendar.CalendarEventOccurrenceGenerator;
import org.silverpeas.core.calendar.Recurrence;
import org.silverpeas.core.calendar.ical4j.ICal4JDateCodec;
import org.silverpeas.core.calendar.ical4j.ICal4JRecurrenceCodec;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.exception.NotSupportedException;

@Technical
@Bean
public class ICal4JCalendarEventOccurrenceGenerator
implements CalendarEventOccurrenceGenerator {
    private final ICal4JDateCodec iCal4JDateCodec;
    private final ICal4JRecurrenceCodec iCal4JRecurrenceCodec;

    @Inject
    public ICal4JCalendarEventOccurrenceGenerator(ICal4JDateCodec iCal4JDateCodec, ICal4JRecurrenceCodec iCal4JRecurrenceCodec) {
        this.iCal4JDateCodec = iCal4JDateCodec;
        this.iCal4JRecurrenceCodec = iCal4JRecurrenceCodec;
    }

    public List<CalendarEventOccurrence> generateOccurrencesOf(List<CalendarEvent> events, org.silverpeas.core.date.Period inPeriod) {
        ArrayList<CalendarEventOccurrence> occurrences = new ArrayList<CalendarEventOccurrence>();
        events.forEach(event -> {
            VEvent vEvent = this.fromCalendarEvent((CalendarEvent)event);
            PeriodList periodList = this.getPeriodList(vEvent, inPeriod);
            periodList.forEach(occurPeriod -> {
                CalendarEventOccurrence occurrence = this.buildCalendarEventOccurrence((CalendarEvent)event, (Period)occurPeriod);
                occurrences.add(occurrence);
            });
        });
        occurrences.sort(Comparator.comparing(o -> TemporalConverter.asOffsetDateTime((Temporal)o.getStartDate())));
        return occurrences;
    }

    public long countOccurrencesOf(CalendarEvent event, org.silverpeas.core.date.Period inPeriod) {
        if (!event.isPlanned()) {
            return -1L;
        }
        if (!event.isRecurrent()) {
            return 1L;
        }
        if (event.getRecurrence().isEndless()) {
            return Long.MAX_VALUE;
        }
        RRule recurrenceRule = this.generateRecurrenceRule(event);
        Date firstOccurrenceStartDate = (Date)TemporalConverter.applyByType((Temporal)event.getStartDate(), (TemporalConverter.Conversion[])new TemporalConverter.Conversion[]{this.iCal4JDateCodec.localDateConversion(), this.iCal4JDateCodec.offsetDateTimeConversion()});
        Date periodStartDate = (Date)TemporalConverter.applyByType((Temporal)(inPeriod == null ? event.getStartDate() : inPeriod.getStartDate()), (TemporalConverter.Conversion[])new TemporalConverter.Conversion[]{this.iCal4JDateCodec.localDateConversion(), this.iCal4JDateCodec.offsetDateTimeConversion()});
        Temporal endDate = (Temporal)event.getRecurrence().getEndDate().orElseThrow(() -> new NotSupportedException("Endless period of recurrent event not supported!"));
        Date periodEndDate = (Date)TemporalConverter.applyByType((Temporal)(inPeriod == null ? endDate.plus(1L, ChronoUnit.DAYS) : inPeriod.getEndDate()), (TemporalConverter.Conversion[])new TemporalConverter.Conversion[]{this.iCal4JDateCodec.localDateConversion(), this.iCal4JDateCodec.offsetDateTimeConversion()});
        return recurrenceRule.getRecur().getDates(firstOccurrenceStartDate, periodStartDate, periodEndDate, firstOccurrenceStartDate instanceof DateTime ? Value.DATE_TIME : Value.DATE).size();
    }

    public CalendarEventOccurrence generateNextOccurrenceOf(CalendarEvent event, ZonedDateTime since) {
        if (event.isRecurrent()) {
            return this.generateNextOccurrenceOfRecurrentEvent(event, since);
        }
        return this.generateNextOccurrenceOfSingleEvent(event, since);
    }

    private CalendarEventOccurrence generateNextOccurrenceOfSingleEvent(CalendarEvent event, ZonedDateTime since) {
        ZoneId actualZoneId = event.getCalendar().getZoneId();
        boolean isEventAfter = event.isOnAllDay() ? since.toLocalDate().isBefore((LocalDate)event.getStartDate()) : since.withZoneSameInstant(actualZoneId).isBefore(((OffsetDateTime)event.getStartDate()).atZoneSameInstant(actualZoneId));
        if (isEventAfter) {
            return CalendarEventOccurrenceBuilder.forEvent(event).startingAt(event.getStartDate()).endingAt(event.getEndDate()).build();
        }
        return null;
    }

    private CalendarEventOccurrence generateNextOccurrenceOfRecurrentEvent(CalendarEvent event, ZonedDateTime since) {
        ZoneId actualZoneId = event.getCalendar().getZoneId();
        ZonedDateTime eventStartDate = event.isOnAllDay() ? ((LocalDate)event.getStartDate()).atStartOfDay(actualZoneId) : ((OffsetDateTime)event.getStartDate()).atZoneSameInstant(actualZoneId);
        Optional optionalRecurEndDate = event.getRecurrence().getEndDate();
        LocalDate recurEndDate = null;
        if (optionalRecurEndDate.isPresent()) {
            recurEndDate = optionalRecurEndDate.get() instanceof LocalDate ? (LocalDate)optionalRecurEndDate.get() : ((OffsetDateTime)optionalRecurEndDate.get()).toLocalDate();
        }
        VEvent vEvent = this.fromCalendarEvent(event);
        ChronoUnit recurUnit = event.getRecurrence().getFrequency().getUnit().toChronoUnit();
        ZonedDateTime sinceDateTime = since.withZoneSameInstant(actualZoneId).isBefore(eventStartDate) ? eventStartDate.minusMinutes(1L) : since.withZoneSameInstant(actualZoneId);
        DateTime iCalSinceDate = this.iCal4JDateCodec.encode(sinceDateTime);
        LocalDate searchPeriodStart = sinceDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
        int nbNextStartDateComputations = 0;
        do {
            if (recurEndDate != null && recurEndDate.isBefore(searchPeriodStart)) {
                return null;
            }
            PeriodList occurDateList = this.getPeriodList(vEvent, org.silverpeas.core.date.Period.between((LocalDate)searchPeriodStart, (LocalDate)searchPeriodStart.plus(2L, recurUnit)));
            for (Period nextOccurDate : occurDateList) {
                if (!nextOccurDate.getStart().after((java.util.Date)iCalSinceDate)) continue;
                return this.buildCalendarEventOccurrence(event, nextOccurDate);
            }
            searchPeriodStart = searchPeriodStart.plus(2L, recurUnit);
        } while (++nbNextStartDateComputations < 100);
        throw new IllegalStateException("the next date seems to be hard to guess...");
    }

    private CalendarEventOccurrence buildCalendarEventOccurrence(CalendarEvent event, Period occurPeriod) {
        Comparable<OffsetDateTime> occurEnd;
        Comparable<OffsetDateTime> occurStart;
        if (event.isOnAllDay()) {
            occurStart = this.asOffsetDateTime(occurPeriod.getStart()).toLocalDate();
            occurEnd = this.asOffsetDateTime(occurPeriod.getEnd()).toLocalDate();
        } else {
            occurStart = this.asOffsetDateTime(occurPeriod.getStart());
            occurEnd = this.asOffsetDateTime(occurPeriod.getEnd());
        }
        return CalendarEventOccurrenceBuilder.forEvent(event).startingAt((Temporal)((Object)occurStart)).endingAt((Temporal)((Object)occurEnd)).build();
    }

    private RRule generateRecurrenceRule(CalendarEvent event) {
        Recurrence recurrence = event.getRecurrence();
        Recur.Frequency recurrenceType = this.getRecurrentType(recurrence.getFrequency().getUnit());
        Recur.Builder builder = new Recur.Builder().frequency(recurrenceType);
        Optional endDate = recurrence.getRecurrenceEndDate();
        if (endDate.isPresent()) {
            builder.until((Date)TemporalConverter.applyByType((Temporal)((Temporal)endDate.get()), (TemporalConverter.Conversion[])new TemporalConverter.Conversion[]{this.iCal4JDateCodec.localDateConversion(), this.iCal4JDateCodec.offsetDateTimeConversion()}));
        } else if (recurrence.getRecurrenceCount() != 0) {
            builder.count(Integer.valueOf(recurrence.getRecurrenceCount()));
        }
        builder.interval(Integer.valueOf(recurrence.getFrequency().getInterval()));
        WeekDayList dayList = recurrence.getDaysOfWeek().stream().map(dayOfWeekOccurrence -> {
            WeekDay weekDay = this.iCal4JRecurrenceCodec.encode(dayOfWeekOccurrence.dayOfWeek());
            if (recurrence.getFrequency().isWeekly() || recurrence.getFrequency().isDaily() || dayOfWeekOccurrence.nth() == 0) {
                return weekDay;
            }
            return new WeekDay(weekDay, dayOfWeekOccurrence.nth());
        }).collect(Collectors.toCollection(WeekDayList::new));
        builder.dayList(dayList);
        return new RRule(builder.build());
    }

    private Recur.Frequency getRecurrentType(TimeUnit recurrenceUnit) {
        Recur.Frequency recurrenceType;
        switch (recurrenceUnit) {
            case DAY: {
                recurrenceType = Recur.Frequency.DAILY;
                break;
            }
            case WEEK: {
                recurrenceType = Recur.Frequency.WEEKLY;
                break;
            }
            case MONTH: {
                recurrenceType = Recur.Frequency.MONTHLY;
                break;
            }
            case YEAR: {
                recurrenceType = Recur.Frequency.YEARLY;
                break;
            }
            default: {
                throw new NotSupportedException("Recurrence unit not yet supported: " + recurrenceUnit);
            }
        }
        return recurrenceType;
    }

    private VEvent fromCalendarEvent(CalendarEvent event) {
        CalendarComponent component = event.asCalendarComponent();
        Date dtStart = this.iCal4JDateCodec.encode(event.isRecurrent(), component, event.getStartDate());
        Date dtEnd = this.iCal4JDateCodec.encode(event.isRecurrent(), component, event.getEndDate());
        VEvent vEvent = new VEvent(dtStart, dtEnd, event.getTitle());
        vEvent.getProperties().add((Property)new Uid(event.getId()));
        if (event.isRecurrent()) {
            vEvent.getProperties().add((Property)this.generateRecurrenceRule(event));
            if (!event.getRecurrence().getExceptionDates().isEmpty()) {
                vEvent.getProperties().add((Property)new ExDate(this.iCal4JRecurrenceCodec.convertExceptionDates(event)));
            }
        }
        return vEvent;
    }

    private PeriodList getPeriodList(VEvent vEvent, org.silverpeas.core.date.Period inPeriod) {
        Period icalPeriod = this.fromPeriod(inPeriod);
        PeriodList periodList = vEvent.calculateRecurrenceSet(icalPeriod);
        periodList.removeIf(period -> period.getEnd().equals((Object)icalPeriod.getStart()));
        return periodList;
    }

    private Period fromPeriod(org.silverpeas.core.date.Period period) {
        OffsetDateTime start = TemporalConverter.asOffsetDateTime((Temporal)period.getStartDate());
        OffsetDateTime end = TemporalConverter.asOffsetDateTime((Temporal)period.getEndDate());
        return new Period(this.iCal4JDateCodec.encode(start), this.iCal4JDateCodec.encode(end));
    }

    private OffsetDateTime asOffsetDateTime(DateTime dateTime) {
        return dateTime.toInstant().atOffset(ZoneOffset.UTC);
    }
}

