/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.AbstractSearchCriteria;
import org.silverpeas.core.admin.user.model.SearchCriteria;
import org.silverpeas.core.admin.user.model.SearchCriteriaVisitor;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class UserDetailsSearchCriteria
extends AbstractSearchCriteria {
    public static final String[] ANY_GROUPS = SearchCriteria.Constants.ANY;
    private static final String USER_ACCESS_LEVELS = "userAccessLevels";
    private static final String GROUP_IDS = "groupId";
    private static final String USER_IDS = "userIds";
    private static final String USER_SPECIFIC_IDS = "userSpecificIds";
    private static final String DOMAIN_IDS = "domainIds";
    private static final String RESOURCE_ID = "resourceId";
    private static final String INSTANCE_ID = "instanceId";
    private static final String NAME = "name";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String PAGINATION = "pagination";
    private static final String ROLE_GROUPS = "groupIdsInRole";
    private MemoizedSupplier<SilverpeasComponentInstance> componentInstanceSupplier;

    public UserDetailsSearchCriteria() {
        this.criteria.put(USER_IDS, SearchCriteria.Constants.ANY);
    }

    @Override
    public UserDetailsSearchCriteria onName(String name) {
        if (StringUtil.isDefined((String)name)) {
            this.criteria.put(NAME, name);
        }
        return this;
    }

    public SearchCriteria onFirstName(String firstName) {
        if (StringUtil.isDefined((String)firstName)) {
            this.criteria.put(FIRST_NAME, firstName);
        }
        return this;
    }

    public SearchCriteria onLastName(String lastName) {
        if (StringUtil.isDefined((String)lastName)) {
            this.criteria.put(LAST_NAME, lastName);
        }
        return this;
    }

    @Override
    public UserDetailsSearchCriteria onComponentInstanceId(String instanceId) {
        if (StringUtil.isDefined((String)instanceId)) {
            this.criteria.put(INSTANCE_ID, instanceId);
        }
        return this;
    }

    @Override
    public UserDetailsSearchCriteria onRoleNames(String ... roleIds) {
        return (UserDetailsSearchCriteria)super.onRoleNames(roleIds);
    }

    public UserDetailsSearchCriteria withGroupsByRoles(Map<String, Set<String>> groupIdsByRoles) {
        if (!groupIdsByRoles.isEmpty()) {
            this.criteria.put(ROLE_GROUPS, groupIdsByRoles);
        }
        return this;
    }

    @Override
    public UserDetailsSearchCriteria onGroupIds(String ... groupIds) {
        if (ArrayUtils.isNotEmpty((Object[])groupIds)) {
            this.criteria.put(GROUP_IDS, Arrays.stream(groupIds).filter(StringUtil::isDefined).toArray(String[]::new));
        } else if (groupIds == SearchCriteria.Constants.ANY) {
            this.criteria.put(GROUP_IDS, groupIds);
        }
        return this;
    }

    @Override
    public UserDetailsSearchCriteria onDomainIds(String ... domainIds) {
        if (ArrayUtils.isNotEmpty((Object[])domainIds)) {
            this.criteria.put(DOMAIN_IDS, Arrays.stream(domainIds).filter(StringUtil::isDefined).toArray(String[]::new));
        }
        return this;
    }

    @Override
    public UserDetailsSearchCriteria onAccessLevels(UserAccessLevel ... accessLevels) {
        if (ArrayUtils.isNotEmpty((Object[])accessLevels)) {
            this.criteria.put(USER_ACCESS_LEVELS, accessLevels);
        }
        return this;
    }

    @Override
    public UserDetailsSearchCriteria onUserStatesToExclude(UserState ... userStates) {
        return (UserDetailsSearchCriteria)super.onUserStatesToExclude(userStates);
    }

    @Override
    public UserDetailsSearchCriteria includeRemovedUsers() {
        return (UserDetailsSearchCriteria)super.includeRemovedUsers();
    }

    @Override
    public UserDetailsSearchCriteria onResourceId(String resourceId) {
        if (StringUtil.isDefined((String)resourceId)) {
            this.criteria.put(RESOURCE_ID, resourceId);
        }
        return this;
    }

    @Override
    public UserDetailsSearchCriteria onUserIds(String ... userIds) {
        if (ArrayUtils.isNotEmpty((Object[])userIds)) {
            this.criteria.put(USER_IDS, Arrays.stream(userIds).filter(StringUtil::isDefined).toArray(String[]::new));
        }
        return this;
    }

    @Override
    public SearchCriteria onUserSpecificIds(String ... userSpecificIds) {
        if (ArrayUtils.isNotEmpty((Object[])userSpecificIds)) {
            this.criteria.put(USER_SPECIFIC_IDS, Arrays.stream(userSpecificIds).filter(StringUtil::isDefined).toArray(String[]::new));
        }
        return this;
    }

    @Override
    public UserDetailsSearchCriteria onPagination(PaginationPage page) {
        if (page != null) {
            this.criteria.put(PAGINATION, page);
        }
        return this;
    }

    public boolean isCriterionOnGroupsByRolesSet() {
        return this.criteria.containsKey(ROLE_GROUPS) && !((Map)this.criteria.get(ROLE_GROUPS)).isEmpty();
    }

    public boolean isCriterionOnResourceIdSet() {
        return this.criteria.containsKey(RESOURCE_ID);
    }

    public boolean isCriterionOnComponentInstanceIdSet() {
        return this.criteria.containsKey(INSTANCE_ID);
    }

    public boolean isCriterionOnUserIdsSet() {
        return this.criteria.containsKey(USER_IDS) && ArrayUtils.isNotEmpty((Object[])((String[])this.criteria.get(USER_IDS)));
    }

    public boolean isCriterionOnUserSpecificIdsSet() {
        return this.isCriterionOnDomainIdSet() && this.criteria.containsKey(USER_SPECIFIC_IDS);
    }

    public boolean isCriterionOnGroupIdsSet() {
        return this.criteria.containsKey(GROUP_IDS) && ArrayUtils.isNotEmpty((Object[])((String[])this.criteria.get(GROUP_IDS)));
    }

    public boolean isCriterionOnAnyGroupSet() {
        return this.criteria.containsKey(GROUP_IDS) && this.criteria.get(GROUP_IDS) == SearchCriteria.Constants.ANY;
    }

    public boolean isCriterionOnDomainIdSet() {
        return this.criteria.containsKey(DOMAIN_IDS) && ArrayUtils.isNotEmpty((Object[])((String[])this.criteria.get(DOMAIN_IDS)));
    }

    public boolean isCriterionOnAccessLevelsSet() {
        return this.criteria.containsKey(USER_ACCESS_LEVELS);
    }

    public boolean isCriterionOnNameSet() {
        return this.criteria.containsKey(NAME);
    }

    public boolean isCriterionOnFirstNameSet() {
        return this.criteria.containsKey(FIRST_NAME);
    }

    public boolean isCriterionOnLastNameSet() {
        return this.criteria.containsKey(LAST_NAME);
    }

    public boolean isCriterionOnPaginationSet() {
        return this.criteria.containsKey(PAGINATION);
    }

    public Map<String, Set<String>> getCriterionOnGroupsByRoles() {
        return (Map)this.criteria.get(ROLE_GROUPS);
    }

    public String getCriterionOnResourceId() {
        return (String)this.criteria.get(RESOURCE_ID);
    }

    public String getCriterionOnComponentInstanceId() {
        return (String)this.criteria.get(INSTANCE_ID);
    }

    public String[] getCriterionOnUserIds() {
        return (String[])this.criteria.get(USER_IDS);
    }

    public String[] getCriterionOnUserSpecificIds() {
        return (String[])this.criteria.get(USER_SPECIFIC_IDS);
    }

    public String[] getCriterionOnGroupIds() {
        return (String[])this.criteria.get(GROUP_IDS);
    }

    public String[] getCriterionOnDomainIds() {
        return (String[])this.criteria.get(DOMAIN_IDS);
    }

    public UserAccessLevel[] getCriterionOnAccessLevels() {
        return (UserAccessLevel[])this.criteria.get(USER_ACCESS_LEVELS);
    }

    public String getCriterionOnName() {
        return (String)this.criteria.get(NAME);
    }

    public String getCriterionOnFirstName() {
        return (String)this.criteria.get(FIRST_NAME);
    }

    public String getCriterionOnLastName() {
        return (String)this.criteria.get(LAST_NAME);
    }

    public PaginationPage getCriterionOnPagination() {
        return (PaginationPage)this.criteria.get(PAGINATION);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserDetailsSearchCriteria other = (UserDetailsSearchCriteria)obj;
        return Objects.equals(this.criteria, other.criteria);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + this.criteria.hashCode();
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.criteria.isEmpty();
    }

    @Override
    public void accept(SearchCriteriaVisitor visitor) throws SilverpeasRuntimeException {
        visitor.visit(this);
    }

    public Optional<SilverpeasComponentInstance> getNonPublicSharedComponentInstance() {
        if (this.componentInstanceSupplier == null && this.isCriterionOnComponentInstanceIdSet()) {
            throw new IllegalStateException("No supplier of component instances set whereas there is a criterion on them");
        }
        return Optional.ofNullable(this.componentInstanceSupplier).map(MemoizedSupplier::get).filter(i -> !i.isPersonal() && !i.isPublic());
    }

    public void setComponentInstanceSupplier(MemoizedSupplier<SilverpeasComponentInstance> componentInstanceSupplier) {
        this.componentInstanceSupplier = componentInstanceSupplier;
    }
}

