/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service.visitors;

import java.util.HashSet;
import javax.inject.Inject;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.GroupManager;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.admin.user.model.SearchCriteriaVisitor;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public class SearchCriteriaOnSubGroups
implements SearchCriteriaVisitor {
    private final GroupManager groupManager;

    @Inject
    public SearchCriteriaOnSubGroups(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    @Override
    public void visit(UserDetailsSearchCriteria searchCriteria) throws SilverpeasRuntimeException {
        try {
            if (searchCriteria.isCriterionOnGroupIdsSet()) {
                HashSet<String> allGroupsId = new HashSet<String>();
                for (String aGroupId : searchCriteria.getCriterionOnGroupIds()) {
                    allGroupsId.addAll(this.groupManager.getAllSubGroupIdsRecursively(aGroupId));
                    allGroupsId.add(aGroupId);
                }
                searchCriteria.onGroupIds(allGroupsId.toArray(new String[0]));
            }
        }
        catch (AdminException e) {
            throw new SilverpeasRuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public void visit(GroupsSearchCriteria criteria) throws SilverpeasRuntimeException {
    }
}

