/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import com.novell.ldap.LDAPException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ietf.ldap.LDAPLocalException;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.DomainDriver;
import org.silverpeas.core.admin.domain.DomainDriverManager;
import org.silverpeas.core.admin.domain.DomainDriverManagerProvider;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.domain.synchro.SynchroGroupReport;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.user.GroupManager;
import org.silverpeas.core.admin.user.UserManager;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.exception.WithNested;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.expression.PrefixedNotationExpressionEngine;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

class GroupSynchronizationRule {
    private static final Pattern ACCESSLEVEL_STANDARD_DATA_PATTERN = Pattern.compile("(?i)^\\s*ds_accesslevel\\s*=\\s*(\\S+)\\s*$");
    private static final Pattern DOMAIN_STANDARD_DATA_PATTERN = Pattern.compile("(?i)^\\s*ds_domain[s]?\\s*=\\s*(.+)\\s*$");
    private static final Pattern COMPLEMENTARY_DATA_PATTERN = Pattern.compile("(?i)^\\s*dc_([^\\s=]+)\\s*=\\s*(.+)\\s*$");
    private static final Pattern GROUP_RULE_DATA_PATTERN = Pattern.compile("(?i)^\\s*dr_groups(withsubgroups)?\\s*=\\s*(.+)\\s*$");
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("(?i)^\\s*[(].+[)]\\s*$");
    private static final String ADMIN_GET_USER_IDS_BY_SPECIFIC_PROPERTY = "admin.getUserIdsBySpecificProperty";
    private final Group group;
    private final boolean isSharedDomain;
    private List<String> cacheOfAllUserIds = null;

    public static GroupSynchronizationRule from(Group group) {
        return new GroupSynchronizationRule(group);
    }

    private GroupSynchronizationRule(Group group) {
        this.group = group;
        this.isSharedDomain = group.getDomainId() == null || "-1".equals(group.getDomainId());
    }

    public List<String> getUserIds() {
        List<String> userIds = this.evaluateCombinationRule(this.group.getRule());
        return userIds == null || userIds.isEmpty() ? Collections.emptyList() : userIds;
    }

    private static String getRuleExpression(PrefixedNotationExpressionEngine<Optional<List<String>>> combinationEngine, String combinationRule) {
        String rule = combinationRule != null ? combinationRule : "";
        Matcher matcher = EXPRESSION_PATTERN.matcher(rule);
        if (!(matcher.matches() || rule.contains("\\") || combinationEngine.detectOperator(rule))) {
            rule = rule.replaceAll("[(]", "\\\\(").replaceAll("[)]", "\\\\)");
        }
        return rule;
    }

    private List<String> evaluateCombinationRule(String combinationRule) {
        PrefixedNotationExpressionEngine.OperatorFunction negateFunction = new PrefixedNotationExpressionEngine.OperatorFunction("!", (computed, userIds) -> {
            try {
                List<Object> safeComputed = computed.isPresent() ? new ArrayList() : this.getCacheOfAllUserIds();
                safeComputed.removeAll(userIds.orElse(Collections.emptyList()));
                return Optional.of(safeComputed);
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)((Object)e));
            }
        });
        PrefixedNotationExpressionEngine.OperatorFunction andFunction = new PrefixedNotationExpressionEngine.OperatorFunction("&", (computed, userIds) -> {
            List defaultUsersId = userIds.orElse(Collections.emptyList());
            List safeComputed = computed.orElse(defaultUsersId);
            return Optional.of(CollectionUtil.intersection(safeComputed, defaultUsersId));
        });
        PrefixedNotationExpressionEngine.OperatorFunction orFunction = new PrefixedNotationExpressionEngine.OperatorFunction("|", (computed, userIds) -> {
            List safeComputed = computed.orElse(Collections.emptyList());
            return Optional.of(CollectionUtil.union(safeComputed, userIds.orElse(Collections.emptyList())));
        });
        Function<String, Optional> simpleSilverpeasRuleToUserIds = simpleSilverpeasRule -> {
            try {
                return this.evaluateSimpleSilverpeasRule((String)simpleSilverpeasRule);
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException((Throwable)((Object)e));
            }
        };
        PrefixedNotationExpressionEngine combinationEngine = PrefixedNotationExpressionEngine.from(simpleSilverpeasRuleToUserIds, (PrefixedNotationExpressionEngine.OperatorFunction[])new PrefixedNotationExpressionEngine.OperatorFunction[]{negateFunction, andFunction, orFunction});
        try {
            String expression = GroupSynchronizationRule.getRuleExpression((PrefixedNotationExpressionEngine<Optional<List<String>>>)combinationEngine, combinationRule);
            return ((Optional)combinationEngine.evaluate(expression)).orElse(Collections.emptyList());
        }
        catch (RuleError e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuleError(e);
        }
    }

    private Optional<List<String>> evaluateSimpleSilverpeasRule(String simpleSilverpeasRule) throws AdminException {
        if (simpleSilverpeasRule == null) {
            return Optional.empty();
        }
        Matcher matcher = ACCESSLEVEL_STANDARD_DATA_PATTERN.matcher(simpleSilverpeasRule);
        if (matcher.find()) {
            return Optional.of(this.getUserIdsByAccessLevel(matcher.group(1)));
        }
        matcher = DOMAIN_STANDARD_DATA_PATTERN.matcher(simpleSilverpeasRule);
        if (matcher.find()) {
            List<String> domainIds = Arrays.asList(matcher.group(1).replaceAll("\\s", "").split(","));
            ArrayList<String> userIds = new ArrayList<String>();
            for (String domainId : domainIds) {
                userIds.addAll(this.getUserIdsByDomain(domainId));
            }
            return Optional.of(userIds);
        }
        matcher = GROUP_RULE_DATA_PATTERN.matcher(simpleSilverpeasRule);
        if (matcher.find()) {
            boolean withSubGroups = StringUtil.isDefined((String)matcher.group(1));
            String groupValues = matcher.group(2).replaceAll("\\s", "");
            List<String> groupIds = Arrays.asList(groupValues.split(","));
            return Optional.of(this.getUserIdsByGroups(groupIds, withSubGroups));
        }
        matcher = COMPLEMENTARY_DATA_PATTERN.matcher(simpleSilverpeasRule);
        if (matcher.find()) {
            String propertyName = matcher.group(1);
            String propertyValue = matcher.group(2);
            HashSet<String> userIds = new HashSet<String>();
            userIds.addAll(this.getUserIdsBySpecificProperty(propertyName, propertyValue));
            userIds.addAll(this.getUserIdsByExtraFormFieldValue(propertyName, propertyValue));
            return Optional.of(new ArrayList(userIds));
        }
        SilverLogger.getLogger((Object)this).error("ground rule '" + simpleSilverpeasRule + "' for groupId '" + this.group.getId() + "' is not correct !", new Object[0]);
        throw new GroundRuleError(simpleSilverpeasRule);
    }

    private List<String> getUserIdsByGroups(List<String> groupIds, boolean withSubGroups) throws AdminException {
        HashSet<String> allGroupIds = new HashSet<String>();
        for (String currentGroupId : new HashSet<String>(groupIds)) {
            allGroupIds.add(currentGroupId);
            if (!withSubGroups) continue;
            allGroupIds.addAll(this.getGroupManager().getAllSubGroupIdsRecursively(currentGroupId));
        }
        return this.getUserManager().getAllUserIdsInGroups(new ArrayList<String>(allGroupIds));
    }

    private List<String> getUserIdsByDomain(String domainId) throws AdminException {
        if (this.isSharedDomain) {
            return this.getUserManager().getAllUserIdsInDomain(domainId);
        }
        return Collections.emptyList();
    }

    private List<String> getUserIdsByAccessLevel(String accessLevel) throws AdminException {
        List<String> userIds = "*".equalsIgnoreCase(accessLevel) ? (this.isSharedDomain ? this.getUserManager().getAllUsersIds() : this.getUserManager().getAllUserIdsInDomain(this.group.getDomainId())) : (this.isSharedDomain ? Arrays.asList(this.getUserManager().getUserIdsByAccessLevel(UserAccessLevel.fromCode((String)accessLevel))) : Arrays.asList(this.getUserManager().getUserIdsByDomainAndByAccessLevel(this.group.getDomainId(), UserAccessLevel.fromCode((String)accessLevel))));
        return userIds;
    }

    private List<String> getUserIdsBySpecificProperty(String propertyName, String propertyValue) throws AdminException {
        ArrayList<String> userIds = new ArrayList();
        if (this.isSharedDomain) {
            Domain[] domains;
            for (Domain domain : domains = AdministrationServiceProvider.getAdminService().getAllDomains()) {
                userIds.addAll(this.getUserIdsBySpecificProperty(domain.getId(), propertyName, propertyValue));
            }
        } else {
            userIds = this.getUserIdsBySpecificProperty(this.group.getDomainId(), propertyName, propertyValue);
        }
        return userIds;
    }

    private List<String> getUserIdsByExtraFormFieldValue(String fieldName, String fieldValue) {
        PublicationTemplate directoryTemplate = PublicationTemplateManager.getInstance().getDirectoryTemplate();
        if (directoryTemplate != null) {
            try {
                List<DataRecord> records = directoryTemplate.getRecordSet().getRecords(fieldName, fieldValue);
                return records.stream().map(r -> User.getById((String)r.getId())).filter(u -> u != null && !u.isRemovedState()).filter(u -> this.isSharedDomain || u.getDomainId().equals(this.group.getDomainId())).map(User::getId).collect(Collectors.toList());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private List<String> getUserIdsBySpecificProperty(String domainId, String propertyName, String propertyValue) throws AdminException {
        Object[] users = new UserDetail[]{};
        DomainDriverManager domainDriverManager = DomainDriverManagerProvider.getCurrentDomainDriverManager();
        DomainDriver domainDriver = null;
        try {
            domainDriver = domainDriverManager.getDomainDriver(domainId);
        }
        catch (Exception e) {
            this.reportInfo(ADMIN_GET_USER_IDS_BY_SPECIFIC_PROPERTY, "Erreur ! Domaine " + domainId + " inaccessible !");
        }
        if (domainDriver != null) {
            try {
                users = domainDriver.getUsersBySpecificProperty(propertyName, propertyValue);
                if (ArrayUtil.isEmpty(users)) {
                    this.reportInfo(ADMIN_GET_USER_IDS_BY_SPECIFIC_PROPERTY, "La propri\u00e9t\u00e9 '" + propertyName + "' n'est pas d\u00e9finie dans le domaine " + domainId);
                }
            }
            catch (AdminException e) {
                Throwable cause = e.getCause();
                if (cause instanceof com.novell.ldap.LDAPLocalException || cause instanceof LDAPLocalException) {
                    this.reportInfo(ADMIN_GET_USER_IDS_BY_SPECIFIC_PROPERTY, "Domain " + domainId + ": " + cause.toString());
                }
                throw e;
            }
            catch (Exception e) {
                throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users by property", (Object)propertyName), e);
            }
        }
        List<Object> usersInDomain = Collections.emptyList();
        if (ArrayUtil.isNotEmpty(users)) {
            List<String> specificIds = Arrays.stream(users).map(UserDetail::getSpecificId).collect(Collectors.toList());
            usersInDomain = this.getUserManager().getUsersBySpecificIdsAndDomainId(specificIds, domainId);
        }
        return usersInDomain.stream().filter(u -> !u.isRemovedState()).map(UserDetail::getId).collect(Collectors.toList());
    }

    private List<String> getCacheOfAllUserIds() throws AdminException {
        if (this.cacheOfAllUserIds == null) {
            this.cacheOfAllUserIds = this.isSharedDomain ? this.getUserManager().getAllUsersIds() : this.getUserManager().getAllUserIdsInDomain(this.group.getDomainId());
        }
        return new ArrayList<String>(this.cacheOfAllUserIds);
    }

    private void reportInfo(String clazz, String message) {
        SynchroGroupReport.info(clazz, message);
    }

    private UserManager getUserManager() {
        return (UserManager)ServiceProvider.getService(UserManager.class, (Annotation[])new Annotation[0]);
    }

    private GroupManager getGroupManager() {
        return (GroupManager)ServiceProvider.getService(GroupManager.class, (Annotation[])new Annotation[0]);
    }

    static class GroundRuleError
    extends RuleError {
        private static final long serialVersionUID = 4003102352897715610L;
        private final String baseRulePart;

        GroundRuleError(String baseRulePart) {
            super(new IllegalArgumentException("expression.groundrule.unknown"));
            this.baseRulePart = baseRulePart;
        }

        String getBaseRulePart() {
            return this.baseRulePart;
        }
    }

    public static class RuleError
    extends RuntimeException {
        private static final long serialVersionUID = -3732193660967552614L;

        public RuleError(Throwable cause) {
            super(cause);
        }

        String getHandledMessage() {
            String message = "";
            Throwable exceptionSource = this.getCause();
            Throwable previousExceptionSource = null;
            while (exceptionSource != null && previousExceptionSource != exceptionSource && StringUtil.isNotDefined((String)message)) {
                previousExceptionSource = exceptionSource;
                if (StringUtil.isDefined((String)exceptionSource.getMessage()) && exceptionSource.getMessage().startsWith("expression.")) {
                    message = exceptionSource.getMessage();
                } else if (exceptionSource instanceof LDAPException || exceptionSource instanceof LDAPLocalException) {
                    message = exceptionSource.toString();
                }
                if (exceptionSource instanceof WithNested) {
                    exceptionSource = ((WithNested)exceptionSource).getNested();
                    continue;
                }
                exceptionSource = exceptionSource.getCause();
            }
            return message;
        }
    }
}

