/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.kernel.util.StringUtil;

public class SpaceUserRoleRow {
    private static final int NO_VALUE = -1;
    private int id = -1;
    private int spaceId = -1;
    private String name = null;
    private String roleName = null;
    private String description = null;
    private int isInherited = 0;

    private SpaceUserRoleRow() {
    }

    public static SpaceUserRoleRow from(SpaceProfileInst spaceProfileInst) {
        SpaceUserRoleRow spaceUserRole = new SpaceUserRoleRow();
        spaceUserRole.id = StringUtil.asInt((String)spaceProfileInst.getId(), (int)-1);
        spaceUserRole.roleName = spaceProfileInst.getName();
        spaceUserRole.name = spaceProfileInst.getLabel();
        spaceUserRole.description = spaceProfileInst.getDescription();
        if (spaceProfileInst.isInherited()) {
            spaceUserRole.isInherited = 1;
        }
        return spaceUserRole;
    }

    public static SpaceUserRoleRow fetch(ResultSet rs) throws SQLException {
        SpaceUserRoleRow sur = new SpaceUserRoleRow();
        sur.id = rs.getInt(1);
        sur.spaceId = rs.getInt(2);
        sur.name = rs.getString(3);
        sur.roleName = rs.getString(4);
        sur.description = rs.getString(5);
        sur.isInherited = rs.getInt(6);
        return sur;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("The identifier must not be negative");
        }
        this.id = id;
    }

    public boolean isIdDefined() {
        return this.id != -1;
    }

    public int getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(int spaceId) {
        this.spaceId = spaceId;
    }

    public String getName() {
        return this.name;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getInheritance() {
        return this.isInherited;
    }
}

