/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.sqldriver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.admin.domain.driver.sqldriver.SQLSettings;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class SQLGroupTable {
    private static final String WHERE = " where ";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private final SQLSettings drvSettings;

    SQLGroupTable(SQLSettings ds) {
        this.drvSettings = ds;
    }

    protected String getColumns() {
        return this.drvSettings.getGroupSpecificIdColumnName() + ", " + this.drvSettings.getGroupParentIdColumnName() + ", " + this.drvSettings.getGroupNameColumnName() + ", " + this.drvSettings.getGroupDescriptionColumnName();
    }

    private GroupDetail fetchGroup(ResultSet rs) throws SQLException {
        GroupDetail g = new GroupDetail();
        g.setSpecificId(Integer.toString(rs.getInt(1)));
        g.setSuperGroupId(Integer.toString(rs.getInt(2)));
        if (rs.wasNull()) {
            g.setSuperGroupId(null);
        }
        g.setName(rs.getString(3));
        g.setDescription(rs.getString(4));
        return g;
    }

    public int createGroup(Connection c, GroupDetail group) throws AdminException {
        int nextId;
        PreparedStatement statement = null;
        String theQuery = "insert into " + this.drvSettings.getGroupTableName() + "(" + this.getColumns() + ") values (?,?,?,?)";
        try {
            statement = c.prepareStatement(theQuery);
            nextId = DBUtil.getNextId((String)this.drvSettings.getGroupTableName(), (String)this.drvSettings.getGroupSpecificIdColumnName());
            statement.setInt(1, nextId);
            String gid = group.getSuperGroupId();
            if (gid == null || gid.isEmpty() || gid.equals("-1")) {
                statement.setNull(2, 4);
            } else {
                statement.setInt(2, Integer.parseInt(gid));
            }
            statement.setString(3, this.drvSettings.trunc(group.getName(), 100));
            statement.setString(4, this.drvSettings.trunc(group.getDescription(), 400));
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
        finally {
            DBUtil.close((Statement)statement);
        }
        return nextId;
    }

    public void deleteGroup(Connection c, int groupId) throws AdminException {
        PreparedStatement statement = null;
        String theQuery = "delete from " + this.drvSettings.getGroupTableName() + WHERE + this.drvSettings.getGroupSpecificIdColumnName() + " = ?";
        try {
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, groupId);
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
        finally {
            DBUtil.close((Statement)statement);
        }
    }

    public void updateGroup(Connection c, GroupDetail g) throws AdminException {
        PreparedStatement statement = null;
        String theQuery = "update " + this.drvSettings.getGroupTableName() + " set " + this.drvSettings.getGroupNameColumnName() + " = ?, " + this.drvSettings.getGroupDescriptionColumnName() + " = ?, " + this.drvSettings.getGroupParentIdColumnName() + " = ?  where " + this.drvSettings.getGroupSpecificIdColumnName() + " = ?";
        try {
            statement = c.prepareStatement(theQuery);
            statement.setString(1, this.drvSettings.trunc(g.getName(), 100));
            statement.setString(2, this.drvSettings.trunc(g.getDescription(), 400));
            if (g.getSuperGroupId() == null) {
                statement.setNull(3, 4);
            } else {
                statement.setInt(3, Integer.parseInt(g.getSuperGroupId()));
            }
            statement.setInt(4, Integer.parseInt(g.getSpecificId()));
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
        finally {
            DBUtil.close((Statement)statement);
        }
    }

    public GroupDetail getGroup(Connection c, int groupId) throws AdminException {
        GroupDetail groupDetail;
        PreparedStatement statement;
        ResultSet rs;
        block5: {
            rs = null;
            statement = null;
            String theQuery = SELECT + this.getColumns() + FROM + this.drvSettings.getGroupTableName() + " where id = ?";
            statement = c.prepareStatement(theQuery);
            statement.setInt(1, groupId);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            GroupDetail groupDetail2 = this.fetchGroup(rs);
            DBUtil.close((ResultSet)rs, (Statement)statement);
            return groupDetail2;
        }
        try {
            groupDetail = null;
        }
        catch (SQLException e) {
            try {
                throw new AdminException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, (Statement)statement);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)rs, (Statement)statement);
        return groupDetail;
    }

    GroupDetail getGroupByName(Connection c, String groupName) throws AdminException {
        GroupDetail groupDetail;
        PreparedStatement statement;
        ResultSet rs;
        block5: {
            rs = null;
            statement = null;
            String theQuery = SELECT + this.getColumns() + FROM + this.drvSettings.getGroupTableName() + " where name = ?";
            statement = c.prepareStatement(theQuery);
            statement.setString(1, groupName);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            GroupDetail groupDetail2 = this.fetchGroup(rs);
            DBUtil.close((ResultSet)rs, (Statement)statement);
            return groupDetail2;
        }
        try {
            groupDetail = null;
        }
        catch (SQLException e) {
            try {
                throw new AdminException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, (Statement)statement);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)rs, (Statement)statement);
        return groupDetail;
    }

    public List<GroupDetail> getAllGroups(Connection c) throws AdminException {
        ArrayList<GroupDetail> arrayList;
        ResultSet rs = null;
        PreparedStatement statement = null;
        ArrayList<GroupDetail> theResult = new ArrayList<GroupDetail>();
        String theQuery = SELECT + this.getColumns() + FROM + this.drvSettings.getGroupTableName();
        try {
            statement = c.prepareStatement(theQuery);
            rs = statement.executeQuery();
            while (rs.next()) {
                theResult.add(this.fetchGroup(rs));
            }
            arrayList = theResult;
        }
        catch (SQLException e) {
            try {
                throw new AdminException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, (Statement)statement);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)rs, (Statement)statement);
        return arrayList;
    }

    List<GroupDetail> getDirectSubGroups(Connection c, int groupId) throws AdminException {
        ArrayList<GroupDetail> arrayList;
        ResultSet rs = null;
        PreparedStatement statement = null;
        ArrayList<GroupDetail> theResult = new ArrayList<GroupDetail>();
        String theQuery = SELECT + this.getColumns() + FROM + this.drvSettings.getGroupTableName() + WHERE + this.drvSettings.getGroupParentIdColumnName();
        try {
            theQuery = groupId == -1 ? theQuery + " is null" : theQuery + " = ?";
            statement = c.prepareStatement(theQuery);
            if (groupId != -1) {
                statement.setInt(1, groupId);
            }
            rs = statement.executeQuery();
            while (rs.next()) {
                theResult.add(this.fetchGroup(rs));
            }
            arrayList = theResult;
        }
        catch (SQLException e) {
            try {
                throw new AdminException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)rs, (Statement)statement);
        return arrayList;
    }
}

