/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.wbe;

import java.time.OffsetDateTime;
import java.util.StringJoiner;
import org.silverpeas.kernel.util.StringUtil;

public class WbeFileLock {
    private String id;
    private OffsetDateTime lastLockDate;

    protected WbeFileLock() {
        this.clear();
    }

    public String id() {
        this.checkTimer();
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.lastLockDate = OffsetDateTime.now();
    }

    public void clear() {
        this.id = "";
        this.lastLockDate = null;
    }

    public boolean exists() {
        this.checkTimer();
        return StringUtil.isDefined((String)this.id) && this.lastLockDate != null;
    }

    private void checkTimer() {
        if (this.lastLockDate != null && this.lastLockDate.plusMinutes(30L).compareTo(OffsetDateTime.now()) < 0) {
            this.clear();
        }
    }

    public String toString() {
        return new StringJoiner(", ", WbeFileLock.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("lastLockDate=" + this.lastLockDate).toString();
    }
}

