/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import javax.xml.bind.DatatypeConverter;
import org.apache.commons.text.StringEscapeUtils;
import org.silverpeas.core.util.Charsets;

public class WebEncodeHelper {
    public static String javaStringToJsString(String input) {
        if (!WebEncodeHelper.isDefined(input)) {
            return "";
        }
        return StringEscapeUtils.escapeEcmaScript((String)input);
    }

    public static String javaStringToHtmlString(String input) {
        if (!WebEncodeHelper.isDefined(input)) {
            return "";
        }
        return StringEscapeUtils.escapeHtml4((String)input).replace("\u0153", "&oelig;");
    }

    public static String escapeXml(String input) {
        if (WebEncodeHelper.isDefined(input)) {
            return StringEscapeUtils.escapeXml11((String)input);
        }
        return "";
    }

    public static String convertBlanksForHtml(String input) {
        if (!WebEncodeHelper.isDefined(input)) {
            return "";
        }
        StringBuilder resSB = new StringBuilder(input.length() + 10);
        block5: for (int i = 0; i < input.length(); ++i) {
            switch (input.charAt(i)) {
                case '\n': {
                    resSB.append("<br/>");
                    continue block5;
                }
                case '\r': {
                    continue block5;
                }
                case '\t': {
                    resSB.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue block5;
                }
                default: {
                    resSB.append(input.charAt(i));
                }
            }
        }
        return resSB.toString();
    }

    public static String javaStringToHtmlParagraphe(String input) {
        String escapedString = WebEncodeHelper.javaStringToHtmlString(input);
        return WebEncodeHelper.convertBlanksForHtml(escapedString);
    }

    public static String htmlStringToJavaString(String input) {
        if (!WebEncodeHelper.isDefined(input)) {
            return "";
        }
        return StringEscapeUtils.unescapeHtml4((String)input);
    }

    public static String convertHTMLEntities(String text) {
        return StringEscapeUtils.escapeHtml4((String)text);
    }

    public static String encodeFilename(String filename) {
        return "=?UTF-8?B?" + DatatypeConverter.printBase64Binary((byte[])filename.getBytes(Charsets.UTF_8)) + "?=";
    }

    private WebEncodeHelper() {
    }

    private static boolean isDefined(String text) {
        return text != null && !text.isEmpty();
    }
}

