/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.thread.task;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.thread.ManagedThreadPool;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;

@Technical
@Singleton
@Bean
public class RequestTaskManager {
    private final ConcurrentMap<Class<? extends AbstractRequestTask<?>>, RequestTaskMonitor<? extends AbstractRequestTask<?>, ?>> tasks = new ConcurrentHashMap();
    private static final int RESTART_WAITING_BEFORE_GETTING_RESULT = 200;

    public static RequestTaskManager get() {
        return ServiceProvider.getService(RequestTaskManager.class, new Annotation[0]);
    }

    private RequestTaskManager() {
    }

    private <T extends AbstractRequestTask<C>, C extends AbstractRequestTask.ProcessContext> boolean startIfNecessary(RequestTaskMonitor<T, C> monitor) {
        if (!monitor.isTaskRunning()) {
            AbstractRequestTask task = (AbstractRequestTask)ServiceProvider.getService(monitor.taskClass, new Annotation[0]);
            try {
                this.debug(monitor.taskClass, "starting a thread in charge of request processing", new Object[0]);
                task.monitor = monitor;
                TaskWatcher taskWatcher = new TaskWatcher(monitor);
                monitor.task = ManagedThreadPool.getPool().invoke(task);
                monitor.taskWatcher = ManagedThreadPool.getPool().invoke(taskWatcher);
                return true;
            }
            catch (InterruptedException e) {
                this.error(monitor.taskClass, "the task {0} can not be invoked", task.getClass().getSimpleName());
                Thread.currentThread().interrupt();
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }
        return false;
    }

    private <T extends AbstractRequestTask<C>, C extends AbstractRequestTask.ProcessContext> boolean restartIfNecessary(RequestTaskMonitor<T, C> monitor) {
        if (!monitor.isTaskRunning() && !monitor.requestList.isEmpty()) {
            this.warn(monitor.taskClass, "the task is not running but there are yet some requests to process!!! ({0} requests queued) restarting it again", monitor.requestList.size());
            return this.startIfNecessary(monitor);
        }
        return false;
    }

    private void warn(Class<?> taskClass, String message, Object ... parameters) {
        this.getLogger().warn(taskClass.getSimpleName() + " - " + message, parameters);
    }

    private void error(Class<?> taskClass, String message, Object ... parameters) {
        this.getLogger().error(taskClass.getSimpleName() + " - " + message, parameters);
    }

    private void debug(Class<?> taskClass, String message, Object ... parameters) {
        this.getLogger().debug(taskClass.getSimpleName() + " - " + message, parameters);
    }

    private SilverLogger getLogger() {
        return SilverLogger.getLogger((String)"silverpeas.core.thread");
    }

    public <T extends AbstractRequestTask<C>, C extends AbstractRequestTask.ProcessContext> boolean isTaskRunning(Class<T> taskClass) {
        Mutable isRunning = Mutable.of((Object)false);
        this.tasks.computeIfPresent(taskClass, (i, m) -> {
            isRunning.set((Object)m.isTaskRunning());
            return m;
        });
        return (Boolean)isRunning.get();
    }

    public <T extends AbstractRequestTask<C>, C extends AbstractRequestTask.ProcessContext> boolean isTaskNotRunning(Class<T> taskClass) {
        return !this.isTaskRunning(taskClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractRequestTask<C>, C extends AbstractRequestTask.ProcessContext> void push(Class<T> taskClass, AbstractRequestTask.Request<C> newRequest) {
        RequestTaskMonitor monitor = this.tasks.computeIfAbsent(taskClass, c -> {
            AbstractRequestTask taskForInit = (AbstractRequestTask)ServiceProvider.getService(c, new Annotation[0]);
            return new RequestTaskMonitor(this, taskForInit);
        });
        List list = monitor.requestList;
        synchronized (list) {
            this.restartIfNecessary(monitor);
        }
        monitor.acquireAccess();
        list = monitor.requestList;
        synchronized (list) {
            this.debug(taskClass, "pushing new request {0} ({1} requests queued before push)", newRequest.getClass().getSimpleName(), monitor.requestList.size());
            String uniqueType = newRequest.getReplacementId();
            boolean replaced = false;
            if (uniqueType != null) {
                this.debug(taskClass, "searching awaiting request {0} of type {1} to replace", newRequest.getClass().getSimpleName(), uniqueType);
                ListIterator it = monitor.requestList.listIterator();
                while (it.hasNext()) {
                    AbstractRequestTask.Request queueRequest = it.next();
                    if (!uniqueType.equals(queueRequest.getReplacementId())) continue;
                    this.debug(taskClass, "replacing awaiting request {0} of type {1} with new one", newRequest.getClass().getSimpleName(), uniqueType);
                    it.set(newRequest);
                    replaced = true;
                    break;
                }
                if (!replaced) {
                    this.debug(taskClass, "no awaiting request {0} of type {1} to replace", newRequest.getClass().getSimpleName(), uniqueType);
                }
            }
            if (!replaced) {
                monitor.requestList.add(newRequest);
            }
            this.startIfNecessary(monitor);
        }
    }

    @PreDestroy
    protected void shutdownAllTasks() {
        this.tasks.forEach((t, m) -> m.shutdown());
        this.tasks.clear();
    }

    ConcurrentMap<Class<? extends AbstractRequestTask<?>>, RequestTaskMonitor<? extends AbstractRequestTask<?>, ?>> getTasks() {
        return this.tasks;
    }

    static class RequestTaskMonitor<T extends AbstractRequestTask<C>, C extends AbstractRequestTask.ProcessContext> {
        final Class<T> taskClass;
        final List<AbstractRequestTask.Request<C>> requestList;
        private final Semaphore queueSemaphore;
        Future<Void> task = null;
        Future<Void> taskWatcher = null;
        final /* synthetic */ RequestTaskManager this$0;

        RequestTaskMonitor(T taskForInit) {
            this.this$0 = this$0;
            int queueLimit = ((AbstractRequestTask)taskForInit).getRequestQueueLimit();
            this.queueSemaphore = queueLimit > 0 ? new Semaphore(queueLimit, true) : null;
            this.requestList = queueLimit > 0 ? new ArrayList<AbstractRequestTask.Request<C>>(queueLimit) : new ArrayList();
            this.taskClass = taskForInit.getClass();
        }

        boolean isTaskRunning() {
            return this.task != null && !this.task.isCancelled() && !this.task.isDone();
        }

        void shutdown() {
            boolean cancelled;
            if (this.isTaskRunning() && !(cancelled = this.task.cancel(true))) {
                this.this$0.warn(RequestTaskMonitor.class, "Cannot cancel task " + this.task.getClass().getSimpleName(), new Object[0]);
            }
        }

        void acquireAccess() {
            if (this.queueSemaphore != null) {
                try {
                    this.this$0.debug(this.taskClass, "acquiring queue semaphore ({0} available permits before acquire)", this.queueSemaphore.availablePermits());
                    this.queueSemaphore.acquire();
                }
                catch (InterruptedException e) {
                    this.this$0.error(this.taskClass, "not possible to acquire semaphore", new Object[0]);
                    Thread.currentThread().interrupt();
                    throw new SilverpeasRuntimeException((Throwable)e);
                }
            }
        }

        void releaseAccess() {
            if (this.queueSemaphore != null) {
                this.this$0.debug(this.taskClass, "consumer thread - releasing queue semaphore ({0} available permits before release)", this.queueSemaphore.availablePermits());
                this.queueSemaphore.release();
            }
        }
    }

    private class TaskWatcher
    implements Callable<Void> {
        final RequestTaskMonitor<? extends AbstractRequestTask<?>, ? extends AbstractRequestTask.ProcessContext> monitor;

        TaskWatcher(RequestTaskMonitor<? extends AbstractRequestTask<?>, ? extends AbstractRequestTask.ProcessContext> monitor) {
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            RequestTaskManager.this.debug(this.monitor.taskClass, "task watcher - started", new Object[0]);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.error(TaskWatcher.class, e);
                Thread.currentThread().interrupt();
            }
            boolean endedOnError = false;
            try {
                this.monitor.task.get();
            }
            catch (CancellationException | ExecutionException e) {
                endedOnError = true;
                this.error(this.monitor.taskClass, e);
            }
            catch (InterruptedException e) {
                endedOnError = true;
                this.error(this.monitor.taskClass, e);
                Thread.currentThread().interrupt();
            }
            List list = this.monitor.requestList;
            synchronized (list) {
                RequestTaskManager.this.debug(this.monitor.taskClass, "task watcher - watched " + (endedOnError ? "task has been terminated on error" : "task ended without error"), new Object[0]);
                if (!RequestTaskManager.this.restartIfNecessary(this.monitor) && !this.monitor.isTaskRunning()) {
                    RequestTaskManager.this.debug(this.monitor.taskClass, "task watcher - unregistering instances from monitor", new Object[0]);
                    this.monitor.task = null;
                    this.monitor.taskWatcher = null;
                }
            }
            RequestTaskManager.this.debug(this.monitor.taskClass, "task watcher - stopped", new Object[0]);
            return null;
        }

        private void error(Class<?> taskClass, Exception e) {
            RequestTaskManager.this.getLogger().error(taskClass.getSimpleName() + " - an error occurred", (Throwable)e);
        }
    }
}

