/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionModel;
import org.silverpeas.core.contribution.model.NoSuchPropertyException;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.ReminderProcessName;

@Entity
@DiscriminatorValue(value="duration")
public class DurationReminder
extends Reminder {
    private static final long serialVersionUID = -4347609060577633972L;
    @Column(name="trigger_durationTime")
    private Integer duration;
    @Column(name="trigger_durationUnit")
    @Enumerated(value=EnumType.STRING)
    private TimeUnit timeUnit;

    @Override
    public Reminder copy() {
        DurationReminder reminder = (DurationReminder)super.copy();
        reminder.duration = this.duration;
        reminder.timeUnit = this.timeUnit;
        return reminder;
    }

    public DurationReminder(ContributionIdentifier contributionId, ReminderProcessName processName) {
        super(contributionId, processName);
    }

    public DurationReminder(ContributionIdentifier contributionId, User user, ReminderProcessName processName) {
        super(contributionId, user, processName);
    }

    protected DurationReminder() {
    }

    public final DurationReminder withText(String text) {
        return (DurationReminder)super.withText(text);
    }

    public int getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public DurationReminder triggerBefore(int duration, TimeUnit timeUnit, String temporalProperty) {
        this.duration = duration;
        this.timeUnit = timeUnit;
        return (DurationReminder)this.withContributionProperty(temporalProperty);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected OffsetDateTime computeTriggeringDate() {
        OffsetDateTime computedDate = super.computeTriggeringDate();
        if (computedDate == null) {
            OffsetDateTime propertyDateTime;
            ContributionModel model = this.getContribution().getModel();
            ZoneId userZoneId = this.getUserZoneId();
            ZonedDateTime sinceDateTime = ZonedDateTime.now(userZoneId).plus(this.duration.intValue(), Objects.requireNonNull(this.timeUnit.toChronoUnit()));
            try {
                propertyDateTime = this.applyFilterOnTemporalType(model.filterByType(this.getContributionProperty(), sinceDateTime), userZoneId);
            }
            catch (NoSuchPropertyException e) {
                propertyDateTime = this.applyFilterOnTemporalType(model.filterByType(this.getContributionProperty(), new Object[0]), userZoneId);
            }
            computedDate = !propertyDateTime.isBefore(sinceDateTime.toOffsetDateTime()) ? propertyDateTime.minus(this.duration.intValue(), Objects.requireNonNull(this.timeUnit.toChronoUnit())) : null;
        }
        return computedDate;
    }
}

