/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc.sql.setters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.persistence.jdbc.sql.setters.SqlTypedParameterSetter;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
public abstract class SqlTemporalParamSetter
implements SqlTypedParameterSetter {
    protected Instant toInstant(Object value) {
        try {
            if (value instanceof Instant) {
                return (Instant)value;
            }
            Method toInstant = value.getClass().getMethod("toInstant", new Class[0]);
            return (Instant)toInstant.invoke(value, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Date or date time parameter expected. But is " + value.getClass(), e);
        }
    }

    protected void throwTypeNotSupported(Class<?> type) {
        throw new IllegalArgumentException("Type not supported: " + type.getName());
    }
}

