/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.CalendarEventOccurrenceGenerator;
import org.silverpeas.core.calendar.repository.CalendarEventOccurrenceRepository;
import org.silverpeas.core.contribution.model.DefaultContributionModel;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.persistence.datasource.model.jpa.AbstractJpaEntity;
import org.silverpeas.core.util.filter.FilterByType;

public class CalendarEventModel
extends DefaultContributionModel<CalendarEvent> {
    protected CalendarEventModel(CalendarEvent contribution) {
        super(contribution);
    }

    @Override
    public <T> T getProperty(String property, Object ... parameters) {
        if ("NEXT_START_DATE_TIME".equals(property)) {
            ZonedDateTime from = ZonedDateTime.now(((CalendarEvent)this.getContribution()).getCalendar().getZoneId());
            if (parameters.length > 0 && parameters[0] instanceof ZonedDateTime) {
                from = (ZonedDateTime)parameters[0];
            }
            return (T)this.getNextStartDateHour(from);
        }
        return super.getProperty(property, parameters);
    }

    private Temporal getNextStartDateHour(ZonedDateTime since) {
        CalendarEventOccurrence nextOccurrence = CalendarEventOccurrenceGenerator.get().generateNextOccurrenceOf((CalendarEvent)this.getContribution(), since);
        if (nextOccurrence != null) {
            CalendarEventOccurrence adjustedNextOccurrence;
            LocalDate localDate = LocalDate.from(nextOccurrence.getStartDate());
            List<CalendarEventOccurrence> adjustments = CalendarEventOccurrenceRepository.get().getAll(Collections.singletonList(nextOccurrence.getCalendarEvent()), Period.between(localDate, localDate));
            CalendarEventOccurrence calendarEventOccurrence = adjustedNextOccurrence = adjustments.isEmpty() ? nextOccurrence : (CalendarEventOccurrence)adjustments.stream().sorted(Comparator.comparing(AbstractJpaEntity::getId)).filter(o -> {
                if (o.isOnAllDay()) {
                    LocalDate occStartDate = (LocalDate)o.getStartDate();
                    LocalDate oSince = since.toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC).toLocalDate();
                    return !oSince.isAfter(occStartDate);
                }
                OffsetDateTime occStartDate = (OffsetDateTime)o.getStartDate();
                OffsetDateTime oSince = since.toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
                return !oSince.isAfter(occStartDate);
            }).findFirst().orElse(null);
            if (adjustedNextOccurrence != null) {
                return new FilterByType(adjustedNextOccurrence.getStartDate()).matchFirst(LocalDate.class::equals, l -> ((LocalDate)l).atStartOfDay(adjustedNextOccurrence.getCalendarEvent().getCalendar().getZoneId()).toOffsetDateTime()).matchFirst(OffsetDateTime.class::equals, o -> (OffsetDateTime)o).result().orElseThrow(() -> new IllegalArgumentException("date type is not handled"));
            }
        }
        return null;
    }
}

