/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.PortletEvent;
import com.sun.portal.portletcontainer.appengine.PortletAppEngineUtils;
import com.sun.portal.portletcontainer.common.PortletContainerEventRequest;
import com.sun.portal.portletcontainer.common.PortletContainerEventResponse;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.StateAwareResponseImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventResponseImpl
extends StateAwareResponseImpl
implements EventResponse {
    private PortletContainerEventRequest pcEventRequest;
    private PortletContainerEventResponse pcEventResponse;
    private EventRequest eventRequest;

    protected void init(HttpServletRequest request, HttpServletResponse response, PortletContainerEventRequest pcEventRequest, PortletContainerEventResponse pcEventResponse, EventRequest eventRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor) {
        super.init(request, response, pcEventRequest, pcEventResponse, (PortletRequest)eventRequest, portletAppDescriptor, portletDescriptor);
        this.pcEventRequest = pcEventRequest;
        this.pcEventResponse = pcEventResponse;
        this.eventRequest = eventRequest;
    }

    @Override
    protected void clear() {
        super.clear();
        this.pcEventRequest = null;
        this.pcEventResponse = null;
        this.eventRequest = null;
    }

    public void setRenderParameters(Map parameters) {
        this.checkRenderParameterMap(parameters);
        this.pcEventResponse.setRenderParameters(parameters);
    }

    public void setRenderParameter(String key, String value) {
        List<String> deletedRenderParameters = this.getDeletedRenderParameterList(key, value, this.pcEventResponse.getDeletedRenderParameters());
        this.pcEventResponse.setDeletedRenderParameters(deletedRenderParameters);
        Map<String, String[]> renderMap = this.getRenderParameterMap(key, value, this.pcEventResponse.getRenderParameters());
        this.pcEventResponse.setRenderParameters(renderMap);
    }

    public void setRenderParameter(String key, String[] values) {
        Map<String, String[]> renderMap = this.getRenderParameterMap(key, values, this.pcEventResponse.getRenderParameters());
        this.pcEventResponse.setRenderParameters(renderMap);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!this.eventRequest.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Invalid setting window state", windowState);
        }
        this.pcEventResponse.setChannelState(PortletAppEngineUtils.getChannelState(windowState));
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!this.eventRequest.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Attempt to set an invalid portlet mode: ", portletMode);
        }
        this.pcEventResponse.setChannelMode(PortletAppEngineUtils.getChannelMode(portletMode));
    }

    public Map<String, String[]> getRenderParameterMap() {
        Map<String, String[]> map = this.pcEventResponse.getRenderParameters();
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public PortletMode getPortletMode() {
        return PortletAppEngineUtils.getPortletMode(this.pcEventResponse.getChannelMode());
    }

    public WindowState getWindowState() {
        return PortletAppEngineUtils.getWindowState(this.pcEventResponse.getChannelState());
    }

    public void setRenderParameters(EventRequest request) {
        Map immutableRenderParameters = request.getParameterMap();
        HashMap<String, String[]> renderParameters = new HashMap<String, String[]>(immutableRenderParameters.size());
        renderParameters.putAll(immutableRenderParameters);
        this.pcEventResponse.setRenderParameters(renderParameters);
    }

    public void removePublicRenderParameter(String name) {
        if (this.checkIfPublicRenderParameter(name)) {
            List<String> deletedRenderParameters = this.getDeletedRenderParameterList(name, null, this.pcEventResponse.getDeletedRenderParameters());
            this.pcEventResponse.setDeletedRenderParameters(deletedRenderParameters);
        }
    }

    @Override
    protected void setEventQueue(PortletEvent event) {
        ConcurrentLinkedQueue<PortletEvent> eventQueue = (ConcurrentLinkedQueue<PortletEvent>)this.eventRequest.getAttribute("com.sun.portal.portletcontainer.events");
        if (eventQueue == null) {
            eventQueue = new ConcurrentLinkedQueue<PortletEvent>();
        }
        eventQueue.offer(event);
        this.eventRequest.setAttribute("com.sun.portal.portletcontainer.events", eventQueue);
    }
}

